/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.timechart;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.event.ITmfTimestamp;
import org.eclipse.linuxtools.tmf.core.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.core.filter.ITmfFilter;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfTraceUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.linuxtools.tmf.ui.signal.TmfTraceClosedSignal;
import org.eclipse.linuxtools.tmf.ui.signal.TmfTraceOpenedSignal;
import org.eclipse.linuxtools.tmf.ui.viewers.events.ITmfEventsFilterListener;
import org.eclipse.linuxtools.tmf.ui.viewers.events.ITmfEventsFilterProvider;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.linuxtools.tmf.ui.views.colors.ColorSetting;
import org.eclipse.linuxtools.tmf.ui.views.colors.ColorSettingsManager;
import org.eclipse.linuxtools.tmf.ui.views.colors.IColorSettingsListener;
import org.eclipse.linuxtools.tmf.ui.views.timechart.TimeChartAnalysisEntry;
import org.eclipse.linuxtools.tmf.ui.views.timechart.TimeChartAnalysisProvider;
import org.eclipse.linuxtools.tmf.ui.views.timechart.TimeChartDecorationProvider;
import org.eclipse.linuxtools.tmf.ui.views.timechart.TimeChartEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphPresentationProvider;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphRangeListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphSelectionListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.ITimeGraphTimeListener;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphRangeUpdateEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphSelectionEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphTimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;

public class TimeChartView
extends TmfView
implements ITimeGraphRangeListener,
ITimeGraphSelectionListener,
ITimeGraphTimeListener,
IColorSettingsListener,
IResourceChangeListener,
ITmfEventsFilterListener {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.timechart";
    private static final int TIMESTAMP_SCALE = -9;
    private final int fDisplayWidth;
    private TimeGraphViewer fViewer;
    private final ArrayList<TimeChartAnalysisEntry> fTimeAnalysisEntries = new ArrayList();
    private final Map<ITmfTrace<?>, TimeChartDecorationProvider> fDecorationProviders = new HashMap();
    private ArrayList<DecorateThread> fDecorateThreads;
    private long fStartTime = 0L;
    private long fStopTime = Long.MAX_VALUE;
    private boolean fRefreshBusy = false;
    private boolean fRefreshPending = false;
    private final Object fSyncObj = new Object();
    private ITimeGraphPresentationProvider fPresentationProvider;

    public TimeChartView() {
        super("Time Chart");
        this.fDisplayWidth = Display.getDefault().getBounds().width;
    }

    public void createPartControl(Composite parent) {
        IEditorReference[] editorReferences;
        this.fViewer = new TimeGraphViewer(parent, 0);
        this.fPresentationProvider = new TimeChartAnalysisProvider();
        this.fViewer.setTimeGraphProvider(this.fPresentationProvider);
        this.fViewer.setTimeCalendarFormat(true);
        this.fViewer.addRangeListener(this);
        this.fViewer.addSelectionListener(this);
        this.fViewer.setMinimumItemWidth(1);
        IEditorReference[] iEditorReferenceArray = editorReferences = this.getSite().getPage().getEditorReferences();
        int n = editorReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace<?> trace;
            IEditorReference editorReference = iEditorReferenceArray[n2];
            IEditorPart editor = editorReference.getEditor(false);
            if (editor instanceof ITmfTraceEditor && (trace = ((ITmfTraceEditor)editor).getTrace()) != null) {
                IFile bookmarksFile = ((ITmfTraceEditor)editor).getBookmarksFile();
                TimeChartAnalysisEntry timeAnalysisEntry = new TimeChartAnalysisEntry(trace, this.fDisplayWidth * 2);
                this.fTimeAnalysisEntries.add(timeAnalysisEntry);
                this.fDecorationProviders.put(trace, new TimeChartDecorationProvider(bookmarksFile));
                ProcessTraceThread thread = new ProcessTraceThread(timeAnalysisEntry);
                thread.start();
            }
            ++n2;
        }
        this.fViewer.setInput(this.fTimeAnalysisEntries.toArray(new TimeChartAnalysisEntry[0]));
        this.fDecorateThreads = new ArrayList();
        ColorSettingsManager.addColorSettingsListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
    }

    @Override
    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        for (DecorateThread thread : this.fDecorateThreads) {
            thread.cancel();
        }
        ColorSettingsManager.removeColorSettingsListener(this);
        super.dispose();
    }

    public void setFocus() {
        this.fViewer.setFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTraceEntry(TimeChartAnalysisEntry timeAnalysisEntry, long stopRank, long startTime, long stopTime) {
        ITmfTrace<?> trace = timeAnalysisEntry.getTrace();
        TimeChartDecorationProvider decorationProvider = this.fDecorationProviders.get(trace);
        if (decorationProvider == null) {
            return;
        }
        ITmfContext context = null;
        boolean done = false;
        while (!done) {
            TimeChartAnalysisEntry timeChartAnalysisEntry = timeAnalysisEntry;
            synchronized (timeChartAnalysisEntry) {
                if (timeAnalysisEntry.getLastRank() >= trace.getNbEvents()) {
                    done = true;
                    break;
                }
                if (context == null || context.getRank() != timeAnalysisEntry.getLastRank()) {
                    if (context != null) {
                        context.dispose();
                    }
                    context = timeAnalysisEntry.getLastRank() != -1L ? trace.seekEvent(timeAnalysisEntry.getLastRank()) : trace.seekEvent(0L);
                }
                do {
                    long rank = context.getRank();
                    ITmfEvent event = trace.getNext(context);
                    if (event == null) {
                        done = true;
                        break;
                    }
                    TimeChartEvent timeEvent = new TimeChartEvent(timeAnalysisEntry, event, rank, decorationProvider);
                    if (timeEvent.getTime() >= startTime && timeEvent.getTime() <= stopTime) {
                        timeAnalysisEntry.addTraceEvent(timeEvent);
                    }
                    if (context.getRank() != trace.getNbEvents() && context.getRank() != stopRank) continue;
                    done = true;
                    break;
                } while (context.getRank() % (long)trace.getCacheSize() != 1L);
                timeAnalysisEntry.setLastRank(context.getRank());
            }
            this.refreshViewer(false);
        }
        if (context != null) {
            context.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshViewer(boolean resetTimeIntervals) {
        Object object = this.fSyncObj;
        synchronized (object) {
            if (this.fRefreshBusy) {
                this.fRefreshPending = true;
                return;
            }
            this.fRefreshBusy = true;
        }
        final boolean reset = resetTimeIntervals;
        Display.getDefault().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (TimeChartView.this.fViewer.getControl().isDisposed()) {
                    return;
                }
                TimeChartView.this.fViewer.setInput(TimeChartView.this.fTimeAnalysisEntries.toArray(new TimeChartAnalysisEntry[0]));
                if (reset) {
                    TimeChartView.this.fViewer.resetStartFinishTime();
                }
                Object object = TimeChartView.this.fSyncObj;
                synchronized (object) {
                    TimeChartView.this.fRefreshBusy = false;
                    if (TimeChartView.this.fRefreshPending) {
                        TimeChartView.this.fRefreshPending = false;
                        TimeChartView.this.refreshViewer(reset);
                    }
                }
            }
        });
    }

    private void itemize(long startTime, long stopTime) {
        int i = 0;
        while (i < this.fTimeAnalysisEntries.size()) {
            ItemizeThread thread = new ItemizeThread(this.fTimeAnalysisEntries.get(i), startTime, stopTime);
            thread.start();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void redecorate() {
        ArrayList<DecorateThread> arrayList = this.fDecorateThreads;
        synchronized (arrayList) {
            for (DecorateThread thread : this.fDecorateThreads) {
                thread.cancel();
            }
            this.fDecorateThreads.clear();
            int i = 0;
            while (i < this.fTimeAnalysisEntries.size()) {
                DecorateThread thread = new DecorateThread(this.fTimeAnalysisEntries.get(i));
                thread.start();
                this.fDecorateThreads.add(thread);
                ++i;
            }
        }
    }

    @Override
    public void timeRangeUpdated(TimeGraphRangeUpdateEvent event) {
        this.fStartTime = event.getStartTime();
        this.fStopTime = event.getEndTime();
        this.itemize(this.fStartTime, this.fStopTime);
    }

    @Override
    public void selectionChanged(TimeGraphSelectionEvent event) {
        ITimeGraphEntry timeAnalysisEntry = null;
        if (event.getSelection() instanceof TimeChartAnalysisEntry) {
            timeAnalysisEntry = (TimeChartAnalysisEntry)event.getSelection();
        } else if (event.getSelection() instanceof TimeChartEvent) {
            timeAnalysisEntry = ((TimeChartEvent)((Object)event.getSelection())).getEntry();
        }
        if (timeAnalysisEntry instanceof TimeChartAnalysisEntry) {
            this.broadcast((TmfSignal)new TmfTraceSelectedSignal((Object)this, ((TimeChartAnalysisEntry)timeAnalysisEntry).getTrace()));
        }
    }

    @Override
    public void timeSelected(TimeGraphTimeEvent event) {
        this.broadcast((TmfSignal)new TmfTimeSynchSignal((Object)this, (ITmfTimestamp)new TmfTimestamp(event.getTime(), -9)));
    }

    @Override
    public void colorSettingsChanged(ColorSetting[] colorSettings) {
        this.fViewer.setTimeGraphProvider(this.fPresentationProvider);
        this.redecorate();
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] iMarkerDeltaArray = event.findMarkerDeltas("org.eclipse.core.resources.bookmark", false);
        int n = iMarkerDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            for (TimeChartDecorationProvider provider : this.fDecorationProviders.values()) {
                if (!delta.getResource().equals((Object)provider.getBookmarksFile())) continue;
                if (delta.getKind() == 4 && delta.getMarker().getAttribute("location", -1) != -1) {
                    provider.refreshBookmarks();
                    continue;
                }
                if (delta.getKind() != 2) continue;
                provider.refreshBookmarks();
            }
            ++n2;
        }
        this.redecorate();
    }

    @Override
    public void filterApplied(ITmfFilter filter, ITmfTrace<?> trace) {
        TimeChartDecorationProvider decorationProvider = this.fDecorationProviders.get(trace);
        decorationProvider.filterApplied(filter);
        this.redecorate();
    }

    @Override
    public void searchApplied(ITmfFilter filter, ITmfTrace<?> trace) {
        TimeChartDecorationProvider decorationProvider = this.fDecorationProviders.get(trace);
        decorationProvider.searchApplied(filter);
        this.redecorate();
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        if (this.fTimeAnalysisEntries == null) {
            return;
        }
        ITmfTrace<?> trace = signal.getTrace();
        IFile bookmarksFile = signal.getBookmarksFile();
        ITmfEventsFilterProvider eventsFilterProvider = signal.getEventsFilterProvider();
        TimeChartAnalysisEntry timeAnalysisEntry = null;
        int i = 0;
        while (i < this.fTimeAnalysisEntries.size()) {
            if (this.fTimeAnalysisEntries.get(i).getTrace().equals(trace)) {
                timeAnalysisEntry = this.fTimeAnalysisEntries.get(i);
                break;
            }
            ++i;
        }
        if (timeAnalysisEntry == null) {
            timeAnalysisEntry = new TimeChartAnalysisEntry(trace, this.fDisplayWidth * 2);
            this.fTimeAnalysisEntries.add(timeAnalysisEntry);
            this.fDecorationProviders.put(trace, new TimeChartDecorationProvider(bookmarksFile));
            ProcessTraceThread thread = new ProcessTraceThread(timeAnalysisEntry);
            thread.start();
        }
        this.refreshViewer(true);
        if (eventsFilterProvider != null) {
            eventsFilterProvider.addEventsFilterListener(this);
        }
    }

    @TmfSignalHandler
    public void traceClosed(TmfTraceClosedSignal signal) {
        if (this.fTimeAnalysisEntries == null) {
            return;
        }
        ITmfTrace<?> trace = signal.getTrace();
        int i = 0;
        while (i < this.fTimeAnalysisEntries.size()) {
            if (this.fTimeAnalysisEntries.get(i).getTrace().equals(trace)) {
                this.fTimeAnalysisEntries.remove(i);
                this.fDecorationProviders.remove(trace);
                this.refreshViewer(true);
                break;
            }
            ++i;
        }
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getSource() != this && this.fTimeAnalysisEntries != null) {
            ITmfTrace trace = signal.getTrace();
            int i = 0;
            while (i < this.fTimeAnalysisEntries.size()) {
                if (this.fTimeAnalysisEntries.get(i).getTrace().equals((Object)trace)) {
                    this.fViewer.setSelection(this.fTimeAnalysisEntries.get(i));
                    break;
                }
                ++i;
            }
        }
    }

    @TmfSignalHandler
    public void traceUpdated(TmfTraceUpdatedSignal signal) {
        if (this.fTimeAnalysisEntries == null) {
            return;
        }
        ITmfTrace trace = signal.getTrace();
        int i = 0;
        while (i < this.fTimeAnalysisEntries.size()) {
            TimeChartAnalysisEntry timeAnalysisEntry = this.fTimeAnalysisEntries.get(i);
            if (timeAnalysisEntry.getTrace().equals((Object)trace)) {
                this.updateTraceEntry(timeAnalysisEntry, Long.MAX_VALUE, 0L, Long.MAX_VALUE);
                break;
            }
            ++i;
        }
    }

    @TmfSignalHandler
    public void currentTimeUpdated(TmfTimeSynchSignal signal) {
        long time = signal.getCurrentTime().normalize(0L, -9).getValue();
        this.fViewer.setSelectedTime(time, true, this);
    }

    private class DecorateThread
    extends Thread {
        private volatile boolean interrupted;
        private final TimeChartAnalysisEntry fTimeAnalysisEntry;
        private final TimeChartDecorationProvider fDecorationProvider;
        private ITmfContext fContext;
        private int fCount;

        private DecorateThread(TimeChartAnalysisEntry timeAnalysisEntry) {
            super("Decorate Thread:" + timeAnalysisEntry.getName());
            this.interrupted = false;
            this.fCount = 0;
            this.fTimeAnalysisEntry = timeAnalysisEntry;
            this.fDecorationProvider = (TimeChartDecorationProvider)TimeChartView.this.fDecorationProviders.get(timeAnalysisEntry.getTrace());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.resetTraceEntry(this.fTimeAnalysisEntry);
            TimeChartView.this.refreshViewer(false);
            this.decorateTraceEntry(this.fTimeAnalysisEntry, null);
            TimeChartView.this.refreshViewer(false);
            ArrayList arrayList = TimeChartView.this.fDecorateThreads;
            synchronized (arrayList) {
                TimeChartView.this.fDecorateThreads.remove(this);
            }
            if (this.fContext != null) {
                this.fContext.dispose();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetTraceEntry(TimeChartAnalysisEntry timeAnalysisEntry) {
            Iterator<ITimeEvent> iterator = timeAnalysisEntry.getTimeEventsIterator();
            TimeChartEvent event = null;
            boolean hasNext = true;
            while (!this.interrupted && hasNext) {
                TimeChartAnalysisEntry timeChartAnalysisEntry = timeAnalysisEntry;
                synchronized (timeChartAnalysisEntry) {
                    hasNext = iterator.hasNext();
                    if (hasNext) {
                        event = (TimeChartEvent)iterator.next();
                    }
                }
                if (!hasNext) continue;
                event.setColorSettingPriority(Integer.MAX_VALUE);
                if (event.getItemizedEntry() == null) continue;
                this.resetTraceEntry(event.getItemizedEntry());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decorateTraceEntry(TimeChartAnalysisEntry timeAnalysisEntry, TimeChartEvent parentEvent) {
            Iterator<ITimeEvent> iterator = timeAnalysisEntry.getTimeEventsIterator(0L, Long.MAX_VALUE, Long.MAX_VALUE);
            TimeChartEvent event = null;
            int entryPriority = Integer.MAX_VALUE;
            boolean entryIsBookmarked = false;
            boolean entryIsVisible = false;
            boolean entryIsSearchMatch = false;
            boolean hasNext = true;
            while (!this.interrupted && hasNext) {
                TimeChartAnalysisEntry timeChartAnalysisEntry = timeAnalysisEntry;
                synchronized (timeChartAnalysisEntry) {
                    hasNext = iterator.hasNext();
                    if (hasNext) {
                        event = (TimeChartEvent)iterator.next();
                    }
                }
                if (!hasNext) continue;
                if (event.getItemizedEntry() == null) {
                    this.decorateEvent(event);
                } else {
                    this.decorateTraceEntry(event.getItemizedEntry(), event);
                }
                entryPriority = Math.min(entryPriority, event.getColorSettingPriority());
                entryIsBookmarked |= event.isBookmarked();
                entryIsVisible |= event.isVisible();
                entryIsSearchMatch |= event.isSearchMatch();
                if (++this.fCount % timeAnalysisEntry.getTrace().getCacheSize() != 0) continue;
                TimeChartView.this.refreshViewer(false);
            }
            if (parentEvent != null) {
                parentEvent.setColorSettingPriority(entryPriority);
                parentEvent.setIsBookmarked(entryIsBookmarked);
                parentEvent.setIsVisible(entryIsVisible);
                parentEvent.setIsSearchMatch(entryIsSearchMatch);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decorateEvent(TimeChartEvent timeChartEvent) {
            TimeChartAnalysisEntry timeAnalysisEntry = (TimeChartAnalysisEntry)timeChartEvent.getEntry();
            ITmfTrace<?> trace = timeAnalysisEntry.getTrace();
            int priority = Integer.MAX_VALUE;
            boolean isBookmarked = false;
            boolean isVisible = false;
            boolean isSearchMatch = false;
            TimeChartEvent.RankRangeList rankRangeList = timeChartEvent.getRankRangeList();
            synchronized (rankRangeList) {
                block3: for (TimeChartEvent.RankRange range : timeChartEvent.getRankRangeList()) {
                    if (this.interrupted) {
                        return;
                    }
                    if (this.fContext == null || this.fContext.getRank() != range.getFirstRank()) {
                        if (this.fContext != null) {
                            this.fContext.dispose();
                        }
                        this.fContext = trace.seekEvent(range.getFirstRank());
                        this.fContext.setRank(range.getFirstRank());
                    }
                    do {
                        if (this.interrupted) {
                            return;
                        }
                        long rank = this.fContext.getRank();
                        ITmfEvent event = trace.getNext(this.fContext);
                        if (event == null) continue block3;
                        long eventTime = event.getTimestamp().normalize(0L, -9).getValue();
                        if (eventTime >= timeChartEvent.getTime() && eventTime <= timeChartEvent.getTime() + timeChartEvent.getDuration()) {
                            priority = Math.min(priority, ColorSettingsManager.getColorSettingPriority(event));
                        }
                        isBookmarked |= this.fDecorationProvider.isBookmark(rank);
                        isVisible |= this.fDecorationProvider.isVisible(event);
                        isSearchMatch |= this.fDecorationProvider.isSearchMatch(event);
                    } while (this.fContext.getRank() <= range.getLastRank());
                }
            }
            timeChartEvent.setColorSettingPriority(priority);
            timeChartEvent.setIsBookmarked(isBookmarked);
            timeChartEvent.setIsVisible(isVisible);
            timeChartEvent.setIsSearchMatch(isSearchMatch);
        }

        public void cancel() {
            this.interrupted = true;
        }
    }

    private class ItemizeThread
    extends Thread {
        private final TimeChartAnalysisEntry fTimeAnalysisEntry;
        private final long fStartTime;
        private final long fStopTime;
        private final long fMaxDuration;

        private ItemizeThread(TimeChartAnalysisEntry timeAnalysisEntry, long startTime, long stopTime) {
            super("Itemize Thread:" + timeAnalysisEntry.getName());
            this.fTimeAnalysisEntry = timeAnalysisEntry;
            this.fStartTime = startTime;
            this.fStopTime = stopTime;
            this.fMaxDuration = 3L * (this.fStopTime - this.fStartTime) / (long)TimeChartView.this.fDisplayWidth;
        }

        @Override
        public void run() {
            this.itemizeTraceEntry(this.fTimeAnalysisEntry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void itemizeTraceEntry(TimeChartAnalysisEntry timeAnalysisEntry) {
            Iterator<ITimeEvent> iterator = timeAnalysisEntry.getTimeEventsIterator();
            TimeChartEvent event = null;
            boolean hasNext = true;
            while (hasNext) {
                TimeChartAnalysisEntry timeChartAnalysisEntry = timeAnalysisEntry;
                synchronized (timeChartAnalysisEntry) {
                    while (hasNext = iterator.hasNext()) {
                        event = (TimeChartEvent)iterator.next();
                        if (event.getTime() + event.getDuration() > this.fStartTime && event.getTime() < this.fStopTime && event.getDuration() > this.fMaxDuration && event.getNbEvents() > 1L) break;
                    }
                }
                if (!hasNext) continue;
                if (event.getItemizedEntry() == null) {
                    this.itemizeEvent(event);
                    continue;
                }
                this.itemizeTraceEntry(event.getItemizedEntry());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void itemizeEvent(TimeChartEvent event) {
            TimeChartEvent timeChartEvent = event;
            synchronized (timeChartEvent) {
                if (event.isItemizing()) {
                    return;
                }
                event.setItemizing(true);
            }
            TimeChartAnalysisEntry timeAnalysisEntry = new TimeChartAnalysisEntry(this.fTimeAnalysisEntry.getTrace(), (int)Math.min(event.getNbEvents() + 1L, (long)(TimeChartView.this.fDisplayWidth * 2)));
            Object object = event.getRankRangeList();
            synchronized (object) {
                for (TimeChartEvent.RankRange range : event.getRankRangeList()) {
                    timeAnalysisEntry.setLastRank(range.getFirstRank());
                    TimeChartView.this.updateTraceEntry(timeAnalysisEntry, range.getLastRank() + 1L, event.getTime(), event.getTime() + event.getDuration());
                }
            }
            event.setItemizedEntry(timeAnalysisEntry);
            TimeChartView.this.refreshViewer(false);
            this.itemizeTraceEntry(timeAnalysisEntry);
            object = event;
            synchronized (object) {
                event.setItemizing(false);
            }
        }
    }

    private class ProcessTraceThread
    extends Thread {
        private final TimeChartAnalysisEntry fTimeAnalysisEntry;

        public ProcessTraceThread(TimeChartAnalysisEntry timeAnalysisEntry) {
            super("ProcessTraceJob:" + timeAnalysisEntry.getName());
            this.fTimeAnalysisEntry = timeAnalysisEntry;
        }

        @Override
        public void run() {
            TimeChartView.this.updateTraceEntry(this.fTimeAnalysisEntry, Long.MAX_VALUE, 0L, Long.MAX_VALUE);
        }
    }
}

