/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.launch.configuration;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OpEvent;
import org.eclipse.linuxtools.internal.oprofile.core.daemon.OpUnitMask;
import org.eclipse.linuxtools.internal.oprofile.launch.OprofileLaunchMessages;
import org.eclipse.linuxtools.internal.oprofile.launch.OprofileLaunchPlugin;
import org.eclipse.linuxtools.internal.oprofile.launch.configuration.OprofileCounter;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class OprofileEventConfigTab
extends AbstractLaunchConfigurationTab {
    protected Button defaultEventCheck;
    protected OprofileCounter[] counters = OprofileCounter.getCounters(null);
    protected CounterSubTab[] counterSubTabs;

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        this.setControl((Control)top);
        top.setLayout((Layout)new GridLayout());
        if (this.getTimerMode()) {
            Label timerModeLabel = new Label(top, 16384);
            timerModeLabel.setText(OprofileLaunchMessages.getString("tab.event.timermode.no.options"));
        } else {
            this.createVerticalSpacer(top, 1);
            this.defaultEventCheck = new Button(top, 32);
            this.defaultEventCheck.setText(OprofileLaunchMessages.getString("tab.event.defaultevent.button.text"));
            this.defaultEventCheck.setLayoutData((Object)new GridData());
            this.defaultEventCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    OprofileEventConfigTab.this.handleEnabledToggle();
                }
            });
            this.createVerticalSpacer(top, 1);
            OprofileCounter[] counters = OprofileCounter.getCounters(null);
            TabItem[] counterTabs = new TabItem[counters.length];
            this.counterSubTabs = new CounterSubTab[counters.length];
            TabFolder tabFolder = new TabFolder(top, 0);
            tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
            int i = 0;
            while (i < counters.length) {
                CounterSubTab currentTab;
                Composite c = new Composite((Composite)tabFolder, 0);
                this.counterSubTabs[i] = currentTab = new CounterSubTab(c, counters[i]);
                counterTabs[i] = new TabItem(tabFolder, 0);
                counterTabs[i].setControl((Control)c);
                counterTabs[i].setText(String.valueOf(OprofileLaunchMessages.getString("tab.event.counterTab.counterText")) + String.valueOf(i));
                ++i;
            }
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        if (!this.getTimerMode()) {
            try {
                int i = 0;
                while (i < this.counters.length) {
                    this.counters[i].loadConfiguration(config);
                    ++i;
                }
                CounterSubTab[] counterSubTabArray = this.counterSubTabs;
                int n = this.counterSubTabs.length;
                int n2 = 0;
                while (n2 < n) {
                    CounterSubTab tab = counterSubTabArray[n2];
                    tab.initializeTab(config);
                    ++n2;
                }
                boolean enabledState = config.getAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", true);
                this.defaultEventCheck.setSelection(enabledState);
                this.setEnabledState(!enabledState);
                this.updateLaunchConfigurationDialog();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        boolean valid;
        int numEnabledEvents;
        block9: {
            if (this.getTimerMode()) {
                return true;
            }
            numEnabledEvents = 0;
            valid = true;
            try {
                if (config.getAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", false)) {
                    numEnabledEvents = 1;
                    break block9;
                }
                OprofileCounter[] counters = new OprofileCounter[this.getNumberOfCounters()];
                int i = 0;
                while (i < counters.length) {
                    counters[i] = new OprofileCounter(i);
                    counters[i].loadConfiguration(config);
                    if (counters[i].getEnabled()) {
                        ++numEnabledEvents;
                        if (counters[i].getEvent() == null) {
                            valid = false;
                            break;
                        }
                        int min = counters[i].getEvent().getMinCount();
                        if (counters[i].getCount() < min) {
                            valid = false;
                            break;
                        }
                        if (!this.checkEventSetupValidity(counters[i].getNumber(), counters[i].getEvent().getText(), counters[i].getEvent().getUnitMask().getMaskValue())) {
                            valid = false;
                            break;
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return numEnabledEvents > 0 && valid;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        if (this.getTimerMode()) {
            config.setAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", true);
        } else {
            config.setAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", this.defaultEventCheck.getSelection());
            CounterSubTab[] counterSubTabArray = this.counterSubTabs;
            int n = this.counterSubTabs.length;
            int n2 = 0;
            while (n2 < n) {
                CounterSubTab cst = counterSubTabArray[n2];
                cst.performApply(config);
                ++n2;
            }
        }
        try {
            config.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        boolean useDefault = true;
        int i = 0;
        while (i < this.counters.length) {
            this.counters[i].saveConfiguration(config);
            if (this.counters[i].getEnabled()) {
                useDefault = false;
            }
            ++i;
        }
        config.setAttribute("org.eclipse.linuxtools.oprofile.launch.oprofile.USE_DEFAULT_EVENT", useDefault);
        try {
            config.doSave();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public String getName() {
        return OprofileLaunchMessages.getString("tab.event.name");
    }

    public Image getImage() {
        return OprofileLaunchPlugin.getImageDescriptor("icons/event_tab.gif").createImage();
    }

    private void handleEnabledToggle() {
        this.setEnabledState(!this.defaultEventCheck.getSelection());
        this.updateLaunchConfigurationDialog();
    }

    private void setEnabledState(boolean state) {
        CounterSubTab[] counterSubTabArray = this.counterSubTabs;
        int n = this.counterSubTabs.length;
        int n2 = 0;
        while (n2 < n) {
            CounterSubTab cst = counterSubTabArray[n2];
            cst.setEnabledState(state);
            ++n2;
        }
    }

    protected boolean checkEventSetupValidity(int counter, String name, int maskValue) {
        return OprofileLaunchPlugin.getCache().checkEvent(counter, name, maskValue);
    }

    protected boolean getTimerMode() {
        return Oprofile.getTimerMode();
    }

    protected int getNumberOfCounters() {
        return Oprofile.getNumberOfCounters();
    }

    protected class CounterSubTab {
        private Button enabledCheck;
        private Button profileKernelCheck;
        private Button profileUserCheck;
        private Label countTextLabel;
        private Text countText;
        private Label eventDescLabel;
        private Text eventDescText;
        private UnitMaskViewer unitMaskViewer;
        private ListViewer eventList;
        private OprofileCounter counter;
        private ScrolledComposite scrolledTop;
        private Composite tabTopContainer;

        public CounterSubTab(Composite parent, OprofileCounter counter) {
            this.counter = counter;
            parent.setLayout((Layout)new GridLayout());
            ScrolledComposite scrolledContainer = new ScrolledComposite(parent, 768);
            scrolledContainer.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            scrolledContainer.setLayout((Layout)layout);
            scrolledContainer.setExpandHorizontal(true);
            scrolledContainer.setExpandVertical(true);
            Composite tabTopContainer = new Composite((Composite)scrolledContainer, 0);
            scrolledContainer.setContent((Control)tabTopContainer);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            tabTopContainer.setLayout((Layout)layout);
            tabTopContainer.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite topCellComp = new Composite(tabTopContainer, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            topCellComp.setLayout((Layout)layout);
            topCellComp.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
            this.createTopCell(topCellComp);
            OprofileEventConfigTab.this.createVerticalSpacer(tabTopContainer, 2);
            Composite eventListComp = new Composite(tabTopContainer, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            eventListComp.setLayout((Layout)layout);
            this.createLeftCell(eventListComp);
            Composite eventConfigComp = new Composite(tabTopContainer, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            eventConfigComp.setLayout((Layout)layout);
            eventConfigComp.setLayoutData((Object)new GridData(4, 4, true, false));
            this.createRightCell(eventConfigComp);
            GridData data = new GridData(4, 4, false, true);
            data.heightHint = eventConfigComp.getSize().x;
            eventListComp.setLayoutData((Object)data);
            this.scrolledTop = scrolledContainer;
            this.tabTopContainer = tabTopContainer;
        }

        private void createTopCell(Composite parent) {
            this.enabledCheck = new Button(parent, 32);
            this.enabledCheck.setText(OprofileLaunchMessages.getString("tab.event.counterSettings.enabled.button.text"));
            this.enabledCheck.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
            this.enabledCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    CounterSubTab.this.counter.setEnabled(CounterSubTab.this.enabledCheck.getSelection());
                    CounterSubTab.this.internalSetEnabledState(CounterSubTab.this.counter.getEnabled());
                    OprofileEventConfigTab.this.updateLaunchConfigurationDialog();
                }
            });
            this.enabledCheck.setEnabled(false);
            this.eventDescLabel = new Label(parent, 0);
            this.eventDescLabel.setText(OprofileLaunchMessages.getString("tab.event.eventDescription.label.text"));
            this.eventDescLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.eventDescText = new Text(parent, 2060);
            this.eventDescText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }

        private void createLeftCell(Composite parent) {
            this.eventList = new ListViewer(parent, 2820);
            this.eventList.getList().setLayoutData((Object)new GridData(16384, 4, false, true));
            this.eventList.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

                public String getText(Object element) {
                    OpEvent e = (OpEvent)element;
                    return e.getText();
                }

                public Image getImage(Object element) {
                    return null;
                }

                public void addListener(ILabelProviderListener listener) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object element, String property) {
                    return false;
                }

                public void removeListener(ILabelProviderListener listener) {
                }
            });
            this.eventList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    OprofileCounter ctr = (OprofileCounter)inputElement;
                    return ctr.getValidEvents();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
                }
            });
            this.eventList.setInput((Object)this.counter);
            this.eventList.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent sce) {
                    CounterSubTab.this.handleEventListSelectionChange();
                }
            });
        }

        private void createRightCell(Composite parent) {
            this.profileKernelCheck = new Button(parent, 32);
            this.profileKernelCheck.setText(OprofileLaunchMessages.getString("tab.event.counterSettings.profileKernel.check.text"));
            this.profileKernelCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    CounterSubTab.this.handleProfileKernelToggle();
                }
            });
            this.profileUserCheck = new Button(parent, 32);
            this.profileUserCheck.setText(OprofileLaunchMessages.getString("tab.event.counterSettings.profileUser.check.text"));
            this.profileUserCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent se) {
                    CounterSubTab.this.handleProfileUserToggle();
                }
            });
            this.countTextLabel = new Label(parent, 0);
            this.countTextLabel.setText(OprofileLaunchMessages.getString("tab.event.counterSettings.count.label.text"));
            this.countText = new Text(parent, 2052);
            this.countText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.countText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent me) {
                    CounterSubTab.this.handleCountTextModify();
                }
            });
            Composite unitMaskComp = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            unitMaskComp.setLayout((Layout)layout);
            unitMaskComp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.unitMaskViewer = new UnitMaskViewer(unitMaskComp);
        }

        public void initializeTab(ILaunchConfiguration config) {
            this.setEnabledState(false);
            if (config != null) {
                this.counter.loadConfiguration(config);
            }
            boolean enabled = this.counter.getEnabled();
            this.enabledCheck.setSelection(enabled);
            if (this.counter.getEvent() == null) {
                this.counter.setEvent(this.counter.getValidEvents()[0]);
            }
            this.profileKernelCheck.setSelection(this.counter.getProfileKernel());
            this.profileUserCheck.setSelection(this.counter.getProfileUser());
            this.countText.setText(Integer.toString(this.counter.getCount()));
            this.eventDescText.setText(this.counter.getEvent().getTextDescription());
            this.unitMaskViewer.displayEvent(this.counter.getEvent());
            this.eventList.setSelection((ISelection)new StructuredSelection((Object)this.counter.getEvent()));
        }

        public void performApply(ILaunchConfigurationWorkingCopy config) {
            this.counter.saveConfiguration(config);
            try {
                config.doSave();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }

        public void setEnabledState(boolean state) {
            this.enabledCheck.setEnabled(state);
            if (state) {
                this.internalSetEnabledState(this.counter.getEnabled());
            } else {
                this.internalSetEnabledState(false);
            }
        }

        private void internalSetEnabledState(boolean state) {
            this.profileKernelCheck.setEnabled(state);
            this.profileUserCheck.setEnabled(state);
            this.countText.setEnabled(state);
            this.eventDescText.setEnabled(state);
            this.unitMaskViewer.setEnabled(state);
            this.eventList.getList().setEnabled(state);
        }

        private void handleEventListSelectionChange() {
            int index = this.eventList.getList().getSelectionIndex();
            if (index != -1) {
                OpEvent event = (OpEvent)this.eventList.getElementAt(index);
                this.counter.setEvent(event);
                this.eventDescText.setText(event.getTextDescription());
                this.unitMaskViewer.displayEvent(event);
                int min = this.counter.getEvent().getMinCount();
                if (this.counter.getCount() < min) {
                    OprofileEventConfigTab.this.setErrorMessage(this.getMinCountErrorMessage(min));
                }
            }
            OprofileEventConfigTab.this.updateLaunchConfigurationDialog();
        }

        private void handleProfileUserToggle() {
            this.counter.setProfileUser(this.profileUserCheck.getSelection());
            OprofileEventConfigTab.this.updateLaunchConfigurationDialog();
        }

        private void handleProfileKernelToggle() {
            this.counter.setProfileKernel(this.profileKernelCheck.getSelection());
            OprofileEventConfigTab.this.updateLaunchConfigurationDialog();
        }

        private void handleCountTextModify() {
            String errorMessage = null;
            try {
                try {
                    int count = Integer.parseInt(this.countText.getText());
                    this.counter.setCount(count);
                    int min = this.counter.getEvent().getMinCount();
                    if (count < min) {
                        errorMessage = this.getMinCountErrorMessage(min);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    errorMessage = OprofileLaunchMessages.getString("tab.event.counterSettings.count.invalid");
                    this.counter.setCount(-1);
                    OprofileEventConfigTab.this.setErrorMessage(errorMessage);
                    OprofileEventConfigTab.this.updateLaunchConfigurationDialog();
                }
            }
            finally {
                OprofileEventConfigTab.this.setErrorMessage(errorMessage);
                OprofileEventConfigTab.this.updateLaunchConfigurationDialog();
            }
        }

        private String getMinCountErrorMessage(int min) {
            String msg = OprofileLaunchMessages.getString("tab.event.counterSettings.count.too-small");
            Object[] args = new Object[]{min};
            return MessageFormat.format(msg, args);
        }

        private void resizeScrollContainer() {
            this.scrolledTop.setMinSize(this.tabTopContainer.computeSize(-1, -1));
        }

        protected class UnitMaskViewer {
            private Label unitMaskLabel;
            private Composite top;
            private Composite maskListComp;
            private Button[] unitMaskButtons;

            public UnitMaskViewer(Composite parent) {
                this.unitMaskLabel = new Label(parent, 0);
                this.unitMaskLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
                this.unitMaskLabel.setText(OprofileLaunchMessages.getString("unitmaskViewer.label.text"));
                this.unitMaskLabel.setVisible(true);
                Composite top = new Composite(parent, 0);
                top.setLayoutData((Object)new GridData(4, 4, true, true));
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                top.setLayout((Layout)layout);
                this.top = top;
                this.maskListComp = null;
                this.unitMaskButtons = null;
            }

            private void handleToggle(Button maskButton, int index) {
                OpUnitMask mask = CounterSubTab.this.counter.getUnitMask();
                if (mask != null) {
                    if (maskButton.getSelection()) {
                        mask.setMaskFromIndex(index);
                    } else {
                        mask.unSetMaskFromIndex(index);
                    }
                }
                OprofileEventConfigTab.this.updateLaunchConfigurationDialog();
            }

            public void displayEvent(OpEvent oe) {
                OpUnitMask mask = oe.getUnitMask();
                int totalMasks = mask.getNumMasks();
                if (this.maskListComp != null) {
                    this.maskListComp.dispose();
                }
                Composite newMaskComp = new Composite(this.top, 0);
                newMaskComp.setLayout((Layout)new GridLayout());
                newMaskComp.setLayoutData((Object)new GridData(16384, 4, false, true));
                this.maskListComp = newMaskComp;
                mask.setDefaultMaskValue();
                ArrayList<Button> maskButtons = new ArrayList<Button>();
                int i = 0;
                while (i < totalMasks) {
                    Button maskButton;
                    if (mask.getType() == -1) {
                        OprofileCorePlugin.showErrorDialog((String)"opxmlParse", null);
                        return;
                    }
                    if (mask.getType() == 1) {
                        maskButton = new Button(newMaskComp, 16);
                        maskButton.setEnabled(false);
                        maskButton.setText(mask.getText(i));
                        maskButton.setSelection(true);
                    } else {
                        final int maskButtonIndex = i;
                        boolean selected = mask.isMaskSetFromIndex(maskButtonIndex);
                        int buttonType = mask.getType() == 2 ? 16 : 32;
                        maskButton = new Button(newMaskComp, buttonType);
                        maskButton.setEnabled(true);
                        maskButton.setText(mask.getText(i));
                        maskButton.setSelection(selected);
                        maskButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent se) {
                                UnitMaskViewer.this.handleToggle((Button)se.getSource(), maskButtonIndex);
                            }
                        });
                        maskButtons.add(maskButton);
                    }
                    ++i;
                }
                this.unitMaskButtons = new Button[maskButtons.size()];
                maskButtons.toArray(this.unitMaskButtons);
                CounterSubTab.this.resizeScrollContainer();
            }

            public void setEnabled(boolean enabled) {
                if (this.unitMaskButtons != null) {
                    Button[] buttonArray = this.unitMaskButtons;
                    int n = this.unitMaskButtons.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Button b = buttonArray[n2];
                        b.setEnabled(enabled);
                        ++n2;
                    }
                }
            }
        }
    }
}

