/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.ctf.core.trace;

public class StreamInputPacketIndexEntry {
    public static final long INVALID_INDEX = Long.MAX_VALUE;
    private final long offsetBytes;
    private int dataOffsetBits = 0;
    private int packetSizeBits = 0;
    private int contentSizeBits = 0;
    private long timestampBegin = 0L;
    private long timestampEnd = 0L;

    public StreamInputPacketIndexEntry(long offset) {
        this.offsetBytes = offset;
    }

    boolean includes(long ts) {
        return ts >= this.timestampBegin && ts <= this.timestampEnd;
    }

    public String toString() {
        return "StreamInputPacketIndexEntry [offsetBytes=" + this.offsetBytes + ", timestampBegin=" + this.timestampBegin + ", timestampEnd=" + this.timestampEnd + "]";
    }

    public long getOffsetBytes() {
        return this.offsetBytes;
    }

    public int getDataOffsetBits() {
        return this.dataOffsetBits;
    }

    public void setDataOffsetBits(int dataOffsetBits) {
        this.dataOffsetBits = dataOffsetBits;
    }

    public int getPacketSizeBits() {
        return this.packetSizeBits;
    }

    public void setPacketSizeBits(int packetSizeBits) {
        this.packetSizeBits = packetSizeBits;
    }

    public int getContentSizeBits() {
        return this.contentSizeBits;
    }

    public void setContentSizeBits(int contentSizeBits) {
        this.contentSizeBits = contentSizeBits;
    }

    public long getTimestampBegin() {
        return this.timestampBegin;
    }

    public void setTimestampBegin(long timestampBegin) {
        this.timestampBegin = timestampBegin;
    }

    public long getTimestampEnd() {
        return this.timestampEnd;
    }

    public void setTimestampEnd(long timestampEnd) {
        this.timestampEnd = timestampEnd;
    }
}

