/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.editors.c;

import java.util.ArrayList;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.systemtap.ui.editor.ColorManager;
import org.eclipse.linuxtools.systemtap.ui.editor.WhitespaceDetector;
import org.eclipse.linuxtools.systemtap.ui.editor.WordDetector;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.swt.graphics.RGB;

public class CScanner
extends RuleBasedScanner {
    private static String[] fgKeywords = new String[]{"auto", "break", "case", "const", "continue", "default", "do", "else", "extern", "for", "goto", "if", "return", "signed", "sizeof", "static", "switch", "typedef", "unsigned", "volatile", "while"};
    private static String[] fgTypes = new String[]{"char", "double", "enum", "float", "int", "long", "register", "short", "struct", "union", "void", "char*", "double*", "float*", "int*", "long*", "short*", "void*", "u8", "u16", "u32", "u64", "s8", "s16", "s32", ""};
    private static String[] fgConstants = new String[]{"NULL"};
    private ColorManager manager;

    public CScanner(ColorManager manager) {
        LogManager.logDebug((String)("Start CScanner: manager-" + manager), (Object)((Object)this));
        this.manager = manager;
        this.initializeScanner();
        LogManager.logDebug((String)"End CScanner:", (Object)((Object)this));
    }

    public void initializeScanner() {
        LogManager.logDebug((String)"Start initializeScanner:", (Object)((Object)this));
        IPreferenceStore store = IDEPlugin.getDefault().getPreferenceStore();
        RGB cKeyword = PreferenceConverter.getColor((IPreferenceStore)store, (String)"cKeywordColorPreference");
        RGB cType = PreferenceConverter.getColor((IPreferenceStore)store, (String)"cTypeColorPreference");
        RGB cString = PreferenceConverter.getColor((IPreferenceStore)store, (String)"cStringColorPreference");
        RGB cComment = PreferenceConverter.getColor((IPreferenceStore)store, (String)"cCommentColorPreference");
        RGB cDefault = PreferenceConverter.getColor((IPreferenceStore)store, (String)"cDefaultColorPreference");
        RGB cPreprocessor = PreferenceConverter.getColor((IPreferenceStore)store, (String)"cPreprocessorColorPreference");
        Token keyword = new Token((Object)new TextAttribute(this.manager.getColor(cKeyword), null, 1));
        Token type = new Token((Object)new TextAttribute(this.manager.getColor(cType)));
        Token string = new Token((Object)new TextAttribute(this.manager.getColor(cString)));
        Token comment = new Token((Object)new TextAttribute(this.manager.getColor(cComment)));
        Token other = new Token((Object)new TextAttribute(this.manager.getColor(cDefault)));
        Token preprocessor = new Token((Object)new TextAttribute(this.manager.getColor(cPreprocessor)));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("//", (IToken)comment));
        rules.add(new SingleLineRule("#", " ", (IToken)preprocessor));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new WordDetector(), (IToken)other);
        int i = 0;
        while (i < fgKeywords.length) {
            wordRule.addWord(fgKeywords[i], (IToken)keyword);
            ++i;
        }
        i = 0;
        while (i < fgTypes.length) {
            wordRule.addWord(fgTypes[i], (IToken)type);
            ++i;
        }
        i = 0;
        while (i < fgConstants.length) {
            wordRule.addWord(fgConstants[i], (IToken)type);
            ++i;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        this.setDefaultReturnToken((IToken)other);
        rules.toArray(result);
        this.setRules(result);
        LogManager.logDebug((String)"End initializeScanner:", (Object)((Object)this));
    }
}

