/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.editor.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;

public abstract class EditorAction
extends Action
implements IWorkbenchWindowActionDelegate {
    protected IWorkbenchWindow window;
    protected IAction action;

    public EditorAction() {
        this.setEnabled(true);
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }

    protected void updateState() {
        IEditorPart editor = this.getActiveEditor();
        this.setEnabled(editor != null && editor.isDirty());
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    protected IWorkbenchPage getActivePage() {
        return this.getWorkbenchWindow().getActivePage();
    }

    protected IEditorPart getActiveEditor() {
        return this.getActivePage().getActiveEditor();
    }

    public void selectionChanged(IAction act, ISelection select) {
        this.action = act;
        this.buildEnablementChecks();
    }

    protected void buildEnablementChecks() {
        this.setEnablement(true);
    }

    protected void setEnablement(boolean enabled) {
        this.action.setEnabled(enabled);
    }

    public void dispose() {
        this.window = null;
        this.action = null;
    }
}

