/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.callgraph.core.CallgraphCorePlugin;
import org.eclipse.linuxtools.internal.callgraph.core.Messages;

public class SystemTapErrorHandler {
    public static final String FILE_PROP = "errors.prop";
    private final int LINE_LIMIT = 300;
    private boolean errorRecognized = false;
    private StringBuilder errorMessage = new StringBuilder("");
    private StringBuilder logContents;

    public SystemTapErrorHandler() {
        this.errorMessage.append(String.valueOf(Messages.getString("SystemTapErrorHandler.ErrorMessage")) + Messages.getString("SystemTapErrorHandler.ErrorMessage1"));
        this.logContents = new StringBuilder();
    }

    /*
     * Exception decompiling
     */
    public void handle(IProgressMonitor m, String errors) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 18[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void appendToLog(String header) {
        this.logContents.append(header);
    }

    public void handle(IProgressMonitor m, FileReader f) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(f);
        StringBuilder builder = new StringBuilder();
        int counter = 0;
        while ((line = br.readLine()) != null) {
            ++counter;
            builder.append(String.valueOf(line) + "\n");
            if (m != null && m.isCanceled()) {
                return;
            }
            if (counter != 300) continue;
            this.handle(m, builder.toString());
            builder = new StringBuilder();
            counter = 0;
        }
        this.handle(m, builder.toString());
    }

    public void finishHandling(IProgressMonitor m, String scriptPath) {
        if (!this.isErrorRecognized()) {
            this.errorMessage.append(String.valueOf(Messages.getString("SystemTapErrorHandler.NoErrRecognized")) + Messages.getString("SystemTapErrorHandler.NoErrRecognizedMsg"));
        }
        this.writeToLog();
    }

    public void writeToLog() {
        Status status = new Status(4, "org.eclipse.linuxtools.callgraph.core", this.logContents.toString());
        CallgraphCorePlugin.getDefault().getLog().log((IStatus)status);
        this.logContents = new StringBuilder();
    }

    public static void deleteLog(File log) {
        log.delete();
        try {
            log.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isErrorRecognized() {
        return this.errorRecognized;
    }

    private void setErrorRecognized(boolean errorsRecognized) {
        this.errorRecognized = errorsRecognized;
    }

    public String getErrorMessage() {
        return this.errorMessage.toString();
    }

    public String getLogContents() {
        return this.logContents.toString();
    }
}

