/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.progress.UIJob;

public class DocWriter
extends UIJob {
    private TextConsole console;
    private String message;
    private int length;
    private int start;

    public DocWriter(String name, TextConsole console, String message) {
        super(name);
        this.console = console;
        this.message = message;
        this.start = -1;
        this.length = -1;
    }

    public void setStart(int val) {
        this.start = val;
    }

    public void setLength(int val) {
        this.length = val;
    }

    public void setRegion(int start, int length) {
        this.start = start;
        this.length = length;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        if (this.console == null) {
            return Status.CANCEL_STATUS;
        }
        if (this.message == null) {
            return Status.OK_STATUS;
        }
        IDocument doc = this.console.getDocument();
        if (this.length < 0) {
            this.length = 0;
        }
        if (this.start < 0) {
            this.start = doc.getLength();
        }
        try {
            doc.replace(this.start, this.length, this.message);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return Status.OK_STATUS;
    }
}

