/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.core.filter.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.core.filter.model.TmfFilterTreeNode;

public class TmfFilterNode
extends TmfFilterTreeNode {
    public static final String NODE_NAME = "FILTER";
    public static final String NAME_ATTR = "name";
    String fFilterName;

    public TmfFilterNode(String filterName) {
        super(null);
        this.fFilterName = filterName;
    }

    public TmfFilterNode(ITmfFilterTreeNode parent, String filterName) {
        super(parent);
        this.fFilterName = filterName;
    }

    public String getFilterName() {
        return this.fFilterName;
    }

    public void setFilterName(String filterName) {
        this.fFilterName = filterName;
    }

    @Override
    public String getNodeName() {
        return NODE_NAME;
    }

    @Override
    public boolean matches(ITmfEvent event) {
        ITmfFilterTreeNode[] iTmfFilterTreeNodeArray = this.getChildren();
        int n = iTmfFilterTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfFilterTreeNode node = iTmfFilterTreeNodeArray[n2];
            if (node.matches(event)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public List<String> getValidChildren() {
        if (this.getChildrenCount() == 0) {
            return super.getValidChildren();
        }
        return new ArrayList<String>(0);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.getChildrenCount() > 1) {
            buf.append("( ");
        }
        int i = 0;
        while (i < this.getChildrenCount()) {
            ITmfFilterTreeNode node = this.getChildren()[i];
            buf.append(node.toString());
            if (i < this.getChildrenCount() - 1) {
                buf.append(" and ");
            }
            ++i;
        }
        if (this.getChildrenCount() > 1) {
            buf.append(" )");
        }
        return buf.toString();
    }
}

