/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.resources;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.linuxtools.internal.lttng.core.request.ILttngSyntEventRequest;
import org.eclipse.linuxtools.internal.lttng.core.state.evProcessor.ITransEventProcessor;
import org.eclipse.linuxtools.internal.lttng.ui.TraceDebug;
import org.eclipse.linuxtools.internal.lttng.ui.model.trange.ItemContainer;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.ITmfTimeScaleSelectionListener;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.ITmfTimeSelectionListener;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.TmfTimeScaleSelectionEvent;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.TmfTimeSelectionEvent;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.TmfViewerFactory;
import org.eclipse.linuxtools.internal.lttng.ui.viewers.timeAnalysis.model.ITmfTimeAnalysisEntry;
import org.eclipse.linuxtools.internal.lttng.ui.views.common.AbsTimeUpdateView;
import org.eclipse.linuxtools.internal.lttng.ui.views.common.ParamsUpdater;
import org.eclipse.linuxtools.internal.lttng.ui.views.resources.Messages;
import org.eclipse.linuxtools.internal.lttng.ui.views.resources.evProcessor.ResourcesEventToHandlerFactory;
import org.eclipse.linuxtools.internal.lttng.ui.views.resources.model.ResourceModelFactory;
import org.eclipse.linuxtools.internal.lttng.ui.views.resources.model.ResourcesTimeRangeViewerProvider;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.core.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentUpdatedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ResourcesView
extends AbsTimeUpdateView
implements ITmfTimeSelectionListener,
ITmfTimeScaleSelectionListener {
    public static final String ID = "org.eclipse.linuxtools.lttng.ui.views.resources";
    private Action resetScale;
    private Action nextEvent;
    private Action prevEvent;
    private Action nextTrace;
    private Action prevTrace;
    private Action showLegend;
    private Action filterTraces;
    private Action zoomIn;
    private Action zoomOut;
    private Action zoomFilter;
    private Composite top;
    private TmfTimeRange initTimeRange = TmfTimeRange.NULL_RANGE;

    public ResourcesView() {
        super(ID);
    }

    public void createPartControl(Composite parent) {
        this.top = new Composite(parent, 2048);
        this.top.setLayout((Layout)new FillLayout());
        this.tsfviewer = TmfViewerFactory.createViewer(this.top, new ResourcesTimeRangeViewerProvider(this.getParamsUpdater()));
        this.tsfviewer.addWidgetSelectionListner(this);
        this.tsfviewer.addWidgetTimeScaleSelectionListner(this);
        this.tsfviewer.groupTraces(true);
        this.tsfviewer.setAcceptSelectionAPIcalls(true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.tsfviewer.getControl(), "org.eclipse.linuxtools.lttng.ui.views.resource.view");
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        TmfExperiment experiment = TmfExperiment.getCurrentExperiment();
        if (experiment != null) {
            TmfTimeRange experimentTRange = experiment.getTimeRange();
            if (!experimentTRange.equals((Object)TmfTimeRange.NULL_RANGE)) {
                long time0 = experimentTRange.getStartTime().getValue();
                long time1 = experimentTRange.getEndTime().getValue();
                ParamsUpdater paramUpdater = this.getParamsUpdater();
                paramUpdater.update(time0, time1);
                TmfTimeRange adjustedTimeRange = this.initialExperimentDataRequest(this, experimentTRange);
                this.modelUpdateInit(experimentTRange, adjustedTimeRange, this);
            }
        } else {
            TraceDebug.debug("No selected experiment information available");
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ResourcesView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.tsfviewer.getControl());
        this.tsfviewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, this.tsfviewer.getSelectionProvider());
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.showLegend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.resetScale);
        manager.add((IAction)this.nextEvent);
        manager.add((IAction)this.prevEvent);
        manager.add((IAction)this.nextTrace);
        manager.add((IAction)this.prevTrace);
        manager.add((IAction)this.zoomIn);
        manager.add((IAction)this.zoomOut);
        manager.add((IAction)this.zoomFilter);
        manager.add((IContributionItem)new Separator());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.showLegend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.resetScale);
        manager.add((IAction)this.nextEvent);
        manager.add((IAction)this.prevEvent);
        manager.add((IAction)this.nextTrace);
        manager.add((IAction)this.prevTrace);
        manager.add((IAction)this.zoomIn);
        manager.add((IAction)this.zoomOut);
        manager.add((IAction)this.zoomFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.showLegend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.resetScale);
        manager.add((IAction)this.nextEvent);
        manager.add((IAction)this.prevEvent);
        manager.add((IAction)this.nextTrace);
        manager.add((IAction)this.prevTrace);
        manager.add((IAction)this.zoomIn);
        manager.add((IAction)this.zoomOut);
        manager.add((IAction)this.zoomFilter);
        manager.add((IContributionItem)new Separator());
    }

    private void makeActions() {
        this.resetScale = new Action(){

            public void run() {
                if (ResourcesView.this.tsfviewer != null) {
                    ResourcesView.this.tsfviewer.resetStartFinishTime();
                }
            }
        };
        this.resetScale.setText(Messages.getString("ResourcesView.Action.Reset"));
        this.resetScale.setToolTipText(Messages.getString("ResourcesView.Action.Reset.ToolTip"));
        this.resetScale.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ResourcesView.tmf.UI"), (String)"icons/elcl16/home_nav.gif"));
        this.nextEvent = new Action(){

            public void run() {
                if (ResourcesView.this.tsfviewer != null) {
                    ResourcesView.this.tsfviewer.selectNextEvent();
                }
            }
        };
        this.nextEvent.setText(Messages.getString("ResourcesView.Action.NextEvent"));
        this.nextEvent.setToolTipText(Messages.getString("ResourcesView.Action.NextEvent.Tooltip"));
        this.nextEvent.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ResourcesView.tmf.UI"), (String)"icons/elcl16/next_event.gif"));
        this.prevEvent = new Action(){

            public void run() {
                if (ResourcesView.this.tsfviewer != null) {
                    ResourcesView.this.tsfviewer.selectPrevEvent();
                }
            }
        };
        this.prevEvent.setText(Messages.getString("ResourcesView.Action.PrevEvent"));
        this.prevEvent.setToolTipText(Messages.getString("ResourcesView.Action.PrevEvent.Tooltip"));
        this.prevEvent.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ResourcesView.tmf.UI"), (String)"icons/elcl16/prev_event.gif"));
        this.nextTrace = new Action(){

            public void run() {
                if (ResourcesView.this.tsfviewer != null) {
                    ResourcesView.this.tsfviewer.selectNextTrace();
                }
            }
        };
        this.nextTrace.setText(Messages.getString("ResourcesView.Action.NextResource"));
        this.nextTrace.setToolTipText(Messages.getString("ResourcesView.Action.NextResource.ToolTip"));
        this.nextTrace.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ResourcesView.tmf.UI"), (String)"icons/elcl16/next_item.gif"));
        this.prevTrace = new Action(){

            public void run() {
                if (ResourcesView.this.tsfviewer != null) {
                    ResourcesView.this.tsfviewer.selectPrevTrace();
                }
            }
        };
        this.prevTrace.setText(Messages.getString("ResourcesView.Action.PreviousResource"));
        this.prevTrace.setToolTipText(Messages.getString("ResourcesView.Action.PreviousResource.Tooltip"));
        this.prevTrace.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ResourcesView.tmf.UI"), (String)"icons/elcl16/prev_item.gif"));
        this.showLegend = new Action(){

            public void run() {
                if (ResourcesView.this.tsfviewer != null) {
                    ResourcesView.this.tsfviewer.showLegend();
                }
            }
        };
        this.showLegend.setText(Messages.getString("ResourcesView.Action.Legend"));
        this.showLegend.setToolTipText(Messages.getString("ResourcesView.Action.Legend.ToolTip"));
        this.filterTraces = new Action(){

            public void run() {
                if (ResourcesView.this.tsfviewer != null) {
                    ResourcesView.this.tsfviewer.filterTraces();
                }
            }
        };
        this.filterTraces.setText(Messages.getString("ResourcesView.Action.Filter"));
        this.filterTraces.setToolTipText(Messages.getString("ResourcesView.Action.Filter.ToolTip"));
        this.filterTraces.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ResourcesView.tmf.UI"), (String)"icons/elcl16/filter_items.gif"));
        this.zoomIn = new Action(){

            public void run() {
                if (ResourcesView.this.tsfviewer != null) {
                    ResourcesView.this.tsfviewer.zoomIn();
                }
            }
        };
        this.zoomIn.setText(Messages.getString("ResourcesView.Action.ZoomIn"));
        this.zoomIn.setToolTipText(Messages.getString("ResourcesView.Action.ZoomIn.Tooltip"));
        this.zoomIn.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ResourcesView.tmf.UI"), (String)"icons/elcl16/zoomin_nav.gif"));
        this.zoomOut = new Action(){

            public void run() {
                if (ResourcesView.this.tsfviewer != null) {
                    ResourcesView.this.tsfviewer.zoomOut();
                }
            }
        };
        this.zoomOut.setText(Messages.getString("ResourcesView.Action.ZoomOut"));
        this.zoomOut.setToolTipText(Messages.getString("ResourcesView.Action.ZoomOut.tooltip"));
        this.zoomOut.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ResourcesView.tmf.UI"), (String)"icons/elcl16/zoomout_nav.gif"));
        this.zoomFilter = new Action(){

            public void run() {
            }
        };
        this.zoomFilter.setText(Messages.getString("ResourcesView.Action.ZoomFilter"));
        this.zoomFilter.setToolTipText(Messages.getString("ResourcesView.Action.ZoomFilter.tooltip"));
        this.zoomFilter.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)Messages.getString("ResourcesView.tmf.UI"), (String)"icons/elcl16/filter_items.gif"));
        this.zoomFilter.setChecked(false);
    }

    public void setFocus() {
        this.tsfviewer.getControl().setFocus();
    }

    @Override
    public void tsfTmProcessSelEvent(TmfTimeSelectionEvent event) {
        super.tsfTmProcessSelEvent(event);
    }

    @Override
    public void tsfTmProcessTimeScaleEvent(TmfTimeScaleSelectionEvent event) {
        super.tsfTmProcessTimeScaleEvent(event);
    }

    @Override
    public void displayModel(final ITmfTimeAnalysisEntry[] items, final long startBoundTime, final long endBoundTime, final boolean updateTimeBounds, final long startVisibleWindow, final long endVisibleWindow, final Object source) {
        if (this.tsfviewer == null || this.tsfviewer.getControl().isDisposed()) {
            return;
        }
        Display display = this.tsfviewer.getControl().getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ResourcesView.this.tsfviewer != null && !ResourcesView.this.tsfviewer.getControl().isDisposed()) {
                    ResourcesView.this.tsfviewer.display(items, startBoundTime, endBoundTime, updateTimeBounds);
                    if (startVisibleWindow > -1L && endVisibleWindow > -1L) {
                        ResourcesView.this.tsfviewer.setSelectVisTimeWindow(startVisibleWindow, endVisibleWindow, source);
                    }
                    ResourcesView.this.tsfviewer.resizeControls();
                }
            }
        });
    }

    public void dispose() {
        super.dispose();
        this.tsfviewer.removeWidgetSelectionListner(this);
        this.tsfviewer.removeWidgetTimeScaleSelectionListner(this);
        this.tsfviewer = null;
    }

    @Override
    @TmfSignalHandler
    public void synchToTime(TmfTimeSynchSignal signal) {
        super.synchToTime(signal);
    }

    @TmfSignalHandler
    public void synchToTimeRange(TmfRangeSynchSignal signal) {
        if (this.zoomFilter != null) {
            this.synchToTimeRange(signal, this.zoomFilter.isChecked());
        }
    }

    @Override
    public void modelIncomplete(ILttngSyntEventRequest request) {
    }

    @Override
    public ITransEventProcessor getEventProcessor() {
        return ResourcesEventToHandlerFactory.getInstance();
    }

    @TmfSignalHandler
    public void experimentSelected(TmfExperimentSelectedSignal<? extends TmfEvent> signal) {
        if (signal != null) {
            TmfTimeRange experimentTRange = signal.getExperiment().getTimeRange();
            this.initTimeRange = TmfTimeRange.NULL_RANGE;
            if (!experimentTRange.equals((Object)TmfTimeRange.NULL_RANGE)) {
                this.modelUpdateInit(experimentTRange, experimentTRange, signal.getSource());
                this.initialExperimentDataRequest(signal.getSource(), experimentTRange);
            }
        }
    }

    @TmfSignalHandler
    public void experimentRangeUpdated(TmfExperimentRangeUpdatedSignal signal) {
        TmfTimeRange experimentTRange;
        if (this.initTimeRange.equals((Object)TmfTimeRange.NULL_RANGE) && signal.getExperiment().equals(TmfExperiment.getCurrentExperiment()) && !(experimentTRange = signal.getRange()).equals((Object)TmfTimeRange.NULL_RANGE)) {
            this.modelUpdateInit(experimentTRange, experimentTRange, signal.getSource());
            this.initialExperimentDataRequest(signal.getSource(), experimentTRange);
        }
    }

    @TmfSignalHandler
    public void experimentUpdated(TmfExperimentUpdatedSignal signal) {
        TmfTimeRange range;
        if (signal.getExperiment().equals(TmfExperiment.getCurrentExperiment()) && !(range = signal.getExperiment().getTimeRange()).equals((Object)TmfTimeRange.NULL_RANGE)) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (ResourcesView.this.tsfviewer != null && !ResourcesView.this.tsfviewer.getControl().isDisposed()) {
                        ResourcesView.this.tsfviewer.setTimeBounds(range.getStartTime().getValue(), range.getEndTime().getValue());
                    }
                }
            });
        }
    }

    private TmfTimeRange initialExperimentDataRequest(Object source, TmfTimeRange experimentTRange) {
        TmfTimeRange initTimeWindow = this.getInitTRange(experimentTRange);
        this.eventRequest(initTimeWindow, experimentTRange, true, ITmfDataRequest.ExecutionType.FOREGROUND);
        if (TraceDebug.isDEBUG()) {
            TraceDebug.debug("Initialization request time range is: " + initTimeWindow.getStartTime().toString() + "-" + initTimeWindow.getEndTime().toString());
        }
        this.initTimeRange = initTimeWindow;
        return initTimeWindow;
    }

    @Override
    protected ParamsUpdater getParamsUpdater() {
        return ResourceModelFactory.getParamsUpdater();
    }

    @Override
    protected ItemContainer<?> getItemContainer() {
        return ResourceModelFactory.getResourceContainer();
    }

    @Override
    protected int getProviderId() {
        return 2;
    }
}

