/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.model.trange;

import org.eclipse.linuxtools.internal.lttng.core.state.StateStrings;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LTTngCPUState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngBdevState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngIRQState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngSoftIRQState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngTraceState;
import org.eclipse.linuxtools.internal.lttng.core.state.model.LttngTrapState;
import org.eclipse.linuxtools.internal.lttng.ui.model.trange.TimeRangeEventResource;

public class TimeRangeResourceFactory {
    private static TimeRangeResourceFactory instance = null;

    public static TimeRangeResourceFactory getInstance() {
        if (instance == null) {
            instance = new TimeRangeResourceFactory();
        }
        return instance;
    }

    public TimeRangeEventResource createResource(int newId, long newStartTime, long newStopTime, String newName, String newGroupName, String newClassName, TimeRangeEventResource.ResourceTypes type, Long newResourceId, long insertionTime) {
        TimeRangeEventResource resource = null;
        switch (type) {
            case CPU: {
                resource = this.createCpuResource(newId, newStartTime, newStopTime, newName, newGroupName, newClassName, type, newResourceId, insertionTime);
                break;
            }
            case IRQ: {
                resource = this.createIrqResource(newId, newStartTime, newStopTime, newName, newGroupName, newClassName, type, newResourceId, insertionTime);
                break;
            }
            case SOFT_IRQ: {
                resource = this.createSoftIrqResource(newId, newStartTime, newStopTime, newName, newGroupName, newClassName, type, newResourceId, insertionTime);
                break;
            }
            case TRAP: {
                resource = this.createTrapResource(newId, newStartTime, newStopTime, newName, newGroupName, newClassName, type, newResourceId, insertionTime);
                break;
            }
            case BDEV: {
                resource = this.createBdevResource(newId, newStartTime, newStopTime, newName, newGroupName, newClassName, type, newResourceId, insertionTime);
                break;
            }
        }
        return resource;
    }

    private TimeRangeEventResource createIrqResource(int newId, long newStartTime, long newStopTime, String newName, String newGroupName, String newClassName, TimeRangeEventResource.ResourceTypes newType, Long newResourceId, long insertionTime) {
        TimeRangeEventResource resource = new TimeRangeEventResource(newId, newStartTime, newStopTime, newName, newGroupName, newClassName, newType, newResourceId, insertionTime){

            @Override
            public String getStateMode(LttngTraceState traceSt) {
                LttngIRQState irqState = (LttngIRQState)traceSt.getIrq_states().get(this.getResourceId());
                String statemode = "";
                if (irqState != null) {
                    statemode = irqState.peekFromIrqStack().getInName();
                }
                return statemode;
            }
        };
        return resource;
    }

    private TimeRangeEventResource createTrapResource(int newId, long newStartTime, long newStopTime, String newName, String newGroupName, String newClassName, TimeRangeEventResource.ResourceTypes newType, Long newResourceId, long insertionTime) {
        TimeRangeEventResource resource = new TimeRangeEventResource(newId, newStartTime, newStopTime, newName, newGroupName, newClassName, newType, newResourceId, insertionTime){

            @Override
            public String getStateMode(LttngTraceState traceSt) {
                Long trapState;
                String trapStateMode = "";
                LttngTrapState ts = (LttngTrapState)traceSt.getTrap_states().get(this.getResourceId());
                trapStateMode = ts != null ? ((trapState = ts.getRunning()) == 0L ? StateStrings.TrapMode.LTTV_TRAP_IDLE.getInName() : StateStrings.TrapMode.LTTV_TRAP_BUSY.getInName()) : StateStrings.TrapMode.LTTV_TRAP_BUSY.getInName();
                return trapStateMode;
            }
        };
        return resource;
    }

    private TimeRangeEventResource createSoftIrqResource(int newId, long newStartTime, long newStopTime, String newName, String newGroupName, String newClassName, TimeRangeEventResource.ResourceTypes newType, Long newResourceId, long insertionTime) {
        TimeRangeEventResource resource = new TimeRangeEventResource(newId, newStartTime, newStopTime, newName, newGroupName, newClassName, newType, newResourceId, insertionTime){

            @Override
            public String getStateMode(LttngTraceState traceSt) {
                Long softIrqId = this.getResourceId();
                long running = ((LttngSoftIRQState)traceSt.getSoft_irq_states().get(softIrqId)).getRunning();
                long pending = ((LttngSoftIRQState)traceSt.getSoft_irq_states().get(softIrqId)).getPending();
                String softIrqStateMode = running > 0L ? StateStrings.SoftIRQMode.LTTV_SOFT_IRQ_BUSY.getInName() : (pending > 0L ? StateStrings.SoftIRQMode.LTTV_SOFT_IRQ_PENDING.getInName() : StateStrings.SoftIRQMode.LTTV_SOFT_IRQ_IDLE.getInName());
                return softIrqStateMode;
            }
        };
        return resource;
    }

    private TimeRangeEventResource createBdevResource(int newId, long newStartTime, long newStopTime, String newName, String newGroupName, String newClassName, TimeRangeEventResource.ResourceTypes newType, Long newResourceId, long insertionTime) {
        TimeRangeEventResource resource = new TimeRangeEventResource(newId, newStartTime, newStopTime, newName, newGroupName, newClassName, newType, newResourceId, insertionTime){

            @Override
            public String getStateMode(LttngTraceState traceSt) {
                String bdevStateMode = ((LttngBdevState)traceSt.getBdev_states().get(this.getResourceId())).peekFromBdevStack().getInName();
                return bdevStateMode;
            }
        };
        return resource;
    }

    private TimeRangeEventResource createCpuResource(int newId, long newStartTime, long newStopTime, String newName, String newGroupName, String newClassName, TimeRangeEventResource.ResourceTypes newType, Long newResourceId, long insertionTime) {
        TimeRangeEventResource resource = new TimeRangeEventResource(newId, newStartTime, newStopTime, newName, newGroupName, newClassName, newType, newResourceId, insertionTime){

            @Override
            public String getStateMode(LttngTraceState traceSt) {
                LTTngCPUState cpuState = (LTTngCPUState)traceSt.getCpu_states().get(this.getResourceId());
                String cpuStateMode = "";
                if (cpuState != null) {
                    cpuStateMode = ((LTTngCPUState)traceSt.getCpu_states().get(this.getResourceId())).peekFromCpuStack().getInName();
                }
                return cpuStateMode;
            }
        };
        return resource;
    }
}

