/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.wizards;

import java.net.URI;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.linuxtools.tmf.ui.TmfUiPlugin;
import org.eclipse.linuxtools.tmf.ui.project.wizards.Messages;
import org.eclipse.linuxtools.tmf.ui.project.wizards.NewTmfProjectMainWizardPage;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewTmfProjectWizard
extends BasicNewResourceWizard
implements IExecutableExtension {
    private final String fTtitle;
    private final String fDescription;
    protected NewTmfProjectMainWizardPage fMainPage;
    protected String fProjectName;
    protected URI fProjectLocation;
    protected IConfigurationElement fConfigElement;
    protected IProject fProject;

    public NewTmfProjectWizard() {
        this(Messages.NewProjectWizard_DialogHeader, Messages.NewProjectWizard_DialogMessage);
    }

    public NewTmfProjectWizard(String title, String desc) {
        this.setDialogSettings(TmfUiPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(title);
        this.fTtitle = title;
        this.fDescription = desc;
    }

    public void addPages() {
        this.fMainPage = new NewTmfProjectMainWizardPage(Messages.NewProjectWizard_DialogHeader);
        this.fMainPage.setTitle(this.fTtitle);
        this.fMainPage.setDescription(this.fDescription);
        this.addPage((IWizardPage)this.fMainPage);
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        this.fProjectName = this.fMainPage.getProjectName();
        this.fProjectLocation = this.fMainPage.useDefaults() ? null : this.fMainPage.getLocationURI();
        this.fProject = this.createProject(this.fProjectName, this.fProjectLocation, (IProgressMonitor)new NullProgressMonitor());
        BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
        return true;
    }

    private IProject createProject(String projectName, URI projectLocation, IProgressMonitor monitor) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(projectName);
        try {
            IProjectDescription description;
            if (!project.exists()) {
                description = workspace.newProjectDescription(project.getName());
                if (projectLocation != null) {
                    description.setLocationURI(projectLocation);
                }
                project.create(description, monitor);
            }
            if (!project.isOpen()) {
                project.open(monitor);
            }
            description = project.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.linuxtools.tmf.project.nature"});
            project.setDescription(description, null);
            IFolder folder = project.getFolder("Traces");
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            if (!(folder = project.getFolder("Experiments")).exists()) {
                folder.create(true, true, null);
            }
            return project;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fConfigElement = config;
    }
}

