/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.handlers;

import java.io.FileNotFoundException;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.project.handlers.Messages;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class OpenExperimentHandler
extends AbstractHandler {
    private TmfExperimentElement fExperiment = null;

    public boolean isEnabled() {
        TreeSelection sel;
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fExperiment = null;
        if (selection instanceof TreeSelection && (element = (sel = (TreeSelection)selection).getFirstElement()) instanceof TmfExperimentElement) {
            this.fExperiment = (TmfExperimentElement)element;
        }
        return this.fExperiment != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        TmfExperiment currentExperiment = TmfExperiment.getCurrentExperiment();
        if (currentExperiment != null) {
            currentExperiment.dispose();
        }
        List<TmfTraceElement> traceEntries = this.fExperiment.getTraces();
        int nbTraces = traceEntries.size();
        ITmfTrace[] traces = new ITmfTrace[nbTraces];
        int i = 0;
        while (i < nbTraces) {
            TmfTraceElement element = traceEntries.get(i);
            ITmfTrace<?> trace = element.instantiateTrace();
            TmfEvent traceEvent = element.instantiateEvent();
            try {
                trace.initTrace(element.getLocation().getPath(), traceEvent.getClass());
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.displayErrorMsg("");
            }
            traces[i] = trace;
            ++i;
        }
        TmfExperiment experiment = new TmfExperiment(traces[0].getClass(), this.fExperiment.getName(), traces, traces[0].getCacheSize());
        TmfExperiment.setCurrentExperiment((TmfExperiment)experiment);
        TmfSignalManager.dispatchSignal((TmfSignal)new TmfExperimentSelectedSignal((Object)this, experiment));
        return null;
    }

    private void displayErrorMsg(String errorMsg) {
        MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        mb.setText(Messages.OpenTraceHandler_Title);
        mb.setMessage(errorMsg);
        mb.open();
    }
}

