/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.trace;

import org.eclipse.linuxtools.tmf.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.trace.ITmfLocation;

public class TmfContext
implements ITmfContext,
Cloneable {
    private ITmfLocation<? extends Comparable<?>> fLocation;
    private long fRank;

    public TmfContext(ITmfLocation<? extends Comparable<?>> loc, long rank) {
        this.fLocation = loc;
        this.fRank = rank;
    }

    public TmfContext(ITmfLocation<? extends Comparable<?>> location) {
        this(location, -2L);
    }

    public TmfContext(TmfContext other) {
        this(other.fLocation, other.fRank);
    }

    public TmfContext() {
        this(null, -2L);
    }

    @Override
    public void dispose() {
    }

    public void setLocation(ITmfLocation<? extends Comparable<?>> location) {
        this.fLocation = location;
    }

    public ITmfLocation<? extends Comparable<?>> getLocation() {
        return this.fLocation;
    }

    @Override
    public void setRank(long rank) {
        this.fRank = rank;
    }

    @Override
    public long getRank() {
        return this.fRank;
    }

    @Override
    public void updateRank(int delta) {
        if (this.isValidRank()) {
            this.fRank += (long)delta;
        }
    }

    @Override
    public boolean isValidRank() {
        return this.fRank != -2L;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.fLocation.hashCode();
        result = 37 * result + (int)(this.fRank ^ this.fRank >>> 32);
        return result;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof TmfContext)) {
            return false;
        }
        TmfContext o = (TmfContext)other;
        return this.fLocation.equals(o.fLocation) && this.fRank == o.fRank;
    }

    public String toString() {
        return "[TmfContext(" + this.fLocation.toString() + "," + this.fRank + ")]";
    }

    public TmfContext clone() {
        TmfContext clone = null;
        try {
            clone = (TmfContext)super.clone();
            clone.fLocation = this.fLocation.clone();
            clone.fRank = this.fRank;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }
}

