/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.dashboard.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.DashboardGraphData;
import org.eclipse.linuxtools.systemtap.ui.dashboard.structures.GraphTreeNode;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView;
import org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardView;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class ActivateGraphAction
extends Action
implements IViewActionDelegate {
    private GraphTreeNode selectedItem;

    public void init(IViewPart view) {
        this.selectedItem = null;
    }

    public void run(IAction act) {
        this.run();
    }

    public void run() {
        this.run(this.selectedItem);
    }

    public void run(GraphTreeNode selected) {
        Display disp = PlatformUI.getWorkbench().getDisplay();
        Cursor cursor = new Cursor((Device)disp, 1);
        PlatformUI.getWorkbench().getDisplay().getActiveShell().setCursor(cursor);
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardView");
        DashboardGraphData data = (DashboardGraphData)selected.getData();
        data.adapter = ((DashboardView)ivp).createGraph(data.graph, data.data, data.moduleName);
        ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView");
        ActiveModuleBrowserView ambv = (ActiveModuleBrowserView)ivp;
        ambv.getViewer().refresh();
        PlatformUI.getWorkbench().getDisplay().getActiveShell().setCursor(null);
        cursor.dispose();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection selected;
        Object o;
        if (selection instanceof IStructuredSelection && (o = (selected = (IStructuredSelection)selection).getFirstElement()) instanceof GraphTreeNode) {
            this.selectedItem = (GraphTreeNode)((Object)o);
            o = this.selectedItem.getData();
            if (((DashboardGraphData)o).adapter == null) {
                action.setEnabled(true);
                return;
            }
        }
        action.setEnabled(false);
    }

    public void run(GraphTreeNode selected, String module) {
        Display disp = PlatformUI.getWorkbench().getDisplay();
        Cursor cursor = new Cursor((Device)disp, 1);
        PlatformUI.getWorkbench().getDisplay().getActiveShell().setCursor(cursor);
        IViewPart ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.DashboardView");
        DashboardGraphData data = (DashboardGraphData)selected.getData();
        data.adapter = ((DashboardView)ivp).createGraph(data.graph, data.data, module);
        ivp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.linuxtools.systemtap.ui.dashboard.views.ActiveModuleBrowserView");
        ActiveModuleBrowserView ambv = (ActiveModuleBrowserView)ivp;
        ambv.getViewer().refresh();
        PlatformUI.getWorkbench().getDisplay().getActiveShell().setCursor(null);
        cursor.dispose();
    }
}

