/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpmstubby;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyLog;
import org.eclipse.linuxtools.internal.rpmstubby.StubbyPlugin;
import org.eclipse.linuxtools.internal.rpmstubby.model.MainPackage;
import org.eclipse.linuxtools.internal.rpmstubby.model.PackageItem;
import org.eclipse.linuxtools.internal.rpmstubby.model.SubPackage;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StubbyGenerator {
    private MainPackage mainPackage;
    private List<SubPackage> subPackages;

    public StubbyGenerator(MainPackage mainPackage, List<SubPackage> subPackages) {
        this.mainPackage = mainPackage;
        this.subPackages = subPackages;
    }

    public String generateSpecfile() {
        StringBuilder buffer = new StringBuilder();
        String simplePackageName = this.getPackageName(this.mainPackage.getName());
        String packageName = "eclipse-" + simplePackageName;
        buffer.append("%global eclipse_base   %{_libdir}/eclipse\n");
        buffer.append("%global install_loc    %{_datadir}/eclipse/dropins/" + simplePackageName.toLowerCase() + "\n\n");
        buffer.append("Name:           " + packageName.toLowerCase() + "\n");
        buffer.append("Version:        " + this.mainPackage.getVersion().replaceAll("\\.qualifier", "") + "\n");
        buffer.append("Release:        1%{?dist}\n");
        buffer.append("Summary:        " + this.mainPackage.getSummary() + "\n\n");
        buffer.append("Group:          Development/Tools\n");
        buffer.append("License:        " + this.mainPackage.getLicense() + "\n");
        buffer.append("URL:            " + this.mainPackage.getURL() + "\n");
        buffer.append("Source0:        #FIXME\n");
        buffer.append("BuildArch: noarch\n\n");
        buffer.append("BuildRequires: eclipse-pde >= 1:3.4.0\n");
        buffer.append("Requires: eclipse-platform >= 3.4.0\n");
        buffer.append("\n%description\n" + this.mainPackage.getDescription() + "\n");
        for (SubPackage subPackage : this.subPackages) {
            String subPackageName = this.getPackageName(subPackage.getName());
            buffer.append("\n%package  " + subPackageName + "\n");
            buffer.append("Summary:  " + subPackage.getSummary() + "\n");
            buffer.append("Requires: %{name} = %{version}-%{release}\n");
            buffer.append("Group: Development/Tools\n\n");
            buffer.append("%description " + subPackageName + "\n");
            buffer.append(String.valueOf(subPackage.getDescription()) + "\n");
        }
        this.generatePrepSection(buffer);
        this.generateBuildSection(buffer);
        buffer.append("%install\n");
        buffer.append("install -d -m 755 %{buildroot}%{install_loc}\n\n");
        buffer.append("%{__unzip} -q -d %{buildroot}%{install_loc} \\\n");
        buffer.append("     build/rpmBuild/" + this.mainPackage.getName() + ".zip \n\n");
        this.generateFilesSections(buffer);
        buffer.append("%changelog\n\n");
        buffer.append("#FIXME\n");
        return buffer.toString();
    }

    private void generateFilesSections(StringBuilder buffer) {
        buffer.append("%files\n");
        buffer.append("%{install_loc}\n");
        for (String fileName : this.mainPackage.getDocFiles()) {
            buffer.append("%doc ").append(this.mainPackage.getDocFilesRoot()).append("/").append(fileName).append("\n");
        }
        buffer.append("\n");
        for (SubPackage subPackage : this.subPackages) {
            buffer.append("%files " + this.getPackageName(subPackage.getName()) + "\n");
            buffer.append("%dir %{eclipse_base}/features/" + subPackage.getName() + "_*/\n");
            buffer.append("%doc %{eclipse_base}/features/" + subPackage.getName() + "_*/*.html\n");
            buffer.append("%{eclipse_base}/features/" + subPackage.getName() + "_*/feature.*\n");
            buffer.append(String.valueOf(this.getPackageFiles(subPackage.getProvides())) + "\n");
        }
    }

    private void generatePrepSection(StringBuilder buffer) {
        buffer.append("\n%prep\n");
        buffer.append("#FIXME Replace FIXME with the root directory name in Source0\n");
        buffer.append("%setup -q -n FIXME\n\n");
    }

    private void generateBuildSection(StringBuilder buffer) {
        buffer.append("%build\n");
        buffer.append("%{eclipse_base}/buildscripts/pdebuild -f ").append(this.mainPackage.getName());
        buffer.append("\n\n");
    }

    public String getPackageName(String packageName) {
        String[] packageItems = packageName.split("\\.");
        String name = packageItems[packageItems.length - 1];
        if (name.equalsIgnoreCase("feature")) {
            name = packageItems[packageItems.length - 2];
        }
        return name;
    }

    public void writeContent(String projectName, String fileName, String contents) throws CoreException {
        ByteArrayInputStream contentInputStream = new ByteArrayInputStream(contents.getBytes());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(projectName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException("Project \"" + projectName + "\" does not exist.");
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        try {
            ByteArrayInputStream stream = contentInputStream;
            if (file.exists()) {
                file.setContents((InputStream)stream, true, true, null);
            } else {
                file.create((InputStream)stream, true, null);
            }
            ((InputStream)stream).close();
        }
        catch (IOException e) {
            StubbyLog.logError(e);
        }
        StubbyPlugin.getActiveWorkbenchShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException e) {
                    StubbyLog.logError(e);
                }
            }
        });
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.linuxtools.internal.rpmstubby", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    private String getPackageFiles(List<PackageItem> packageItems) {
        StringBuilder toRet = new StringBuilder();
        for (PackageItem packageItem : packageItems) {
            toRet.append("%{eclipse_base}/plugins/").append(packageItem.getName()).append("_*.jar\n");
        }
        return toRet.toString();
    }
}

