/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.project.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.lttng.ui.views.project.ProjectView;
import org.eclipse.linuxtools.lttng.ui.views.project.dialogs.ImportTraceWizard;
import org.eclipse.linuxtools.lttng.ui.views.project.model.ILTTngProjectTreeNode;
import org.eclipse.linuxtools.lttng.ui.views.project.model.LTTngProjectNode;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ImportTraceHandler
implements IHandler {
    private LTTngProjectNode fProject = null;

    public boolean isEnabled() {
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = window.getActivePage();
        if (!(page.getActivePart() instanceof ProjectView)) {
            return false;
        }
        ISelection selection = page.getSelection("org.eclipse.linuxtools.lttng.ui.views.project");
        if (selection instanceof StructuredSelection && (element = ((StructuredSelection)selection).getFirstElement()) instanceof ILTTngProjectTreeNode) {
            ILTTngProjectTreeNode node = (ILTTngProjectTreeNode)element;
            while (node != null && !(node instanceof LTTngProjectNode)) {
                node = node.getParent();
            }
            LTTngProjectNode lTTngProjectNode = this.fProject = node instanceof LTTngProjectNode ? (LTTngProjectNode)node : null;
        }
        return this.fProject != null && this.fProject.isOpen() && this.fProject.isLTTngProject();
    }

    public boolean isHandled() {
        return true;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ProjectView view = (ProjectView)page.getActivePart();
        view.setSelection(this.fProject);
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell shell = workbench.getActiveWorkbenchWindow().getShell();
        ImportTraceWizard wizard = new ImportTraceWizard();
        wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection((Object)this.fProject));
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        dialog.open();
        if (dialog.getReturnCode() == 0 && this.fProject != null) {
            this.fProject.refreshChildren();
            this.fProject.refresh();
        }
        return null;
    }

    public void dispose() {
    }

    public void addHandlerListener(IHandlerListener handlerListener) {
    }

    public void removeHandlerListener(IHandlerListener handlerListener) {
    }
}

