/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.trace;

import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.linuxtools.lttng.TraceHelper;
import org.eclipse.linuxtools.lttng.event.LttngEvent;
import org.eclipse.linuxtools.lttng.event.LttngEventContent;
import org.eclipse.linuxtools.lttng.event.LttngEventReference;
import org.eclipse.linuxtools.lttng.event.LttngEventSource;
import org.eclipse.linuxtools.lttng.event.LttngEventType;
import org.eclipse.linuxtools.lttng.event.LttngLocation;
import org.eclipse.linuxtools.lttng.event.LttngTimestamp;
import org.eclipse.linuxtools.lttng.exceptions.LttngException;
import org.eclipse.linuxtools.lttng.jni.JniEvent;
import org.eclipse.linuxtools.lttng.jni.JniMarker;
import org.eclipse.linuxtools.lttng.jni.JniTrace;
import org.eclipse.linuxtools.lttng.jni.JniTracefile;
import org.eclipse.linuxtools.lttng.jni.common.JniTime;
import org.eclipse.linuxtools.lttng.jni.exception.JniException;
import org.eclipse.linuxtools.lttng.jni.factory.JniTraceFactory;
import org.eclipse.linuxtools.lttng.trace.EventTypeKey;
import org.eclipse.linuxtools.lttng.trace.LTTngTraceVersion;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.trace.TmfCheckpoint;
import org.eclipse.linuxtools.tmf.trace.TmfContext;
import org.eclipse.linuxtools.tmf.trace.TmfTrace;

public class LTTngTrace
extends TmfTrace<LttngEvent> {
    public static boolean PrintDebug = false;
    public static boolean UniqueEvent = true;
    private static final boolean SHOW_LTT_DEBUG_DEFAULT = false;
    private static final boolean IS_PARSING_NEEDED_DEFAULT = !UniqueEvent;
    private static final int CHECKPOINT_PAGE_SIZE = 50000;
    private JniTrace currentJniTrace;
    LttngTimestamp eventTimestamp;
    LttngEventSource eventSource;
    LttngEventContent eventContent;
    LttngEventReference eventReference;
    LttngEvent currentLttngEvent;
    LttngLocation previousLocation;
    LttngEventType eventType;
    HashMap<Integer, LttngEventType> traceTypes;
    Vector<Integer> traceTypeNames;
    private String traceLibPath;
    public int nbEventsRead = 0;

    public LTTngTrace() {
    }

    public boolean validate(IProject project, String path) {
        if (super.validate(project, path)) {
            String traceLibPath = TraceHelper.getTraceLibDirFromProject(project);
            try {
                LTTngTraceVersion version = new LTTngTraceVersion(path, traceLibPath);
                return version.isValidLttngTrace();
            }
            catch (LttngException lttngException) {}
        }
        return false;
    }

    public void initTrace(String path, Class<LttngEvent> eventType) throws FileNotFoundException {
        this.initLTTngTrace(path, eventType, 50000, false);
    }

    public void initTrace(String path, Class<LttngEvent> eventType, int cacheSize) throws FileNotFoundException {
        this.initLTTngTrace(path, eventType, cacheSize, false);
    }

    public void initTrace(String path, Class<LttngEvent> eventType, boolean indexTrace) throws FileNotFoundException {
        this.initLTTngTrace(path, eventType, 50000, indexTrace);
    }

    public void initTrace(String path, Class<LttngEvent> eventType, int cacheSize, boolean indexTrace) throws FileNotFoundException {
        this.initLTTngTrace(path, eventType, cacheSize, indexTrace);
    }

    private void initLTTngTrace(String path, Class<LttngEvent> eventType, int cacheSize, boolean indexTrace) throws FileNotFoundException {
        super.initTrace(path, eventType, indexTrace);
        try {
            this.currentJniTrace = JniTraceFactory.getJniTrace((String)path, (String)this.traceLibPath, (boolean)false);
        }
        catch (Exception e) {
            throw new FileNotFoundException(e.getMessage());
        }
        this.traceTypes = new HashMap();
        this.traceTypeNames = new Vector();
        this.initialiseEventTypes(this.currentJniTrace);
        this.eventTimestamp = new LttngTimestamp();
        this.eventSource = new LttngEventSource();
        this.eventType = new LttngEventType();
        this.eventContent = new LttngEventContent(this.currentLttngEvent);
        this.eventReference = new LttngEventReference(this.getName());
        this.currentLttngEvent = new LttngEvent(this, this.eventTimestamp, this.eventSource, this.eventType, this.eventContent, this.eventReference, null);
        this.previousLocation = new LttngLocation();
        this.eventContent.setEvent(this.currentLttngEvent);
        TmfContext context = this.seekLocation(null);
        LttngEvent event = this.getNextEvent(context);
        LttngTimestamp startTime = new LttngTimestamp(event.getTimestamp());
        LttngTimestamp endTime = new LttngTimestamp(this.currentJniTrace.getEndTime().getTime());
        this.setTimeRange(new TmfTimeRange((TmfTimestamp)startTime, (TmfTimestamp)endTime));
        if (this.currentJniTrace == null) {
            System.out.println("Problem");
        }
    }

    public LTTngTrace(String path) throws Exception {
        this(path, null, true, false);
    }

    public LTTngTrace(String path, boolean waitForCompletion) throws Exception {
        this(path, null, waitForCompletion, true);
    }

    public LTTngTrace(String path, String traceLibPath, boolean waitForCompletion, boolean bypassIndexing) throws Exception {
        super(path, LttngEvent.class, path, 50000, false);
        this.initTrace(path, LttngEvent.class, !bypassIndexing);
        this.traceLibPath = traceLibPath;
    }

    public LTTngTrace(LTTngTrace other) throws Exception {
        this(other.getPath(), other.getTraceLibPath(), false, true);
        this.fCheckpoints = other.fCheckpoints;
        this.setTimeRange(new TmfTimeRange((TmfTimestamp)new LttngTimestamp(other.getStartTime()), (TmfTimestamp)new LttngTimestamp(other.getEndTime())));
    }

    public LTTngTrace copy() {
        LTTngTrace returnedTrace = null;
        try {
            returnedTrace = new LTTngTrace(this);
        }
        catch (Exception e) {
            System.out.println("ERROR : Could not create LTTngTrace copy (createTraceCopy).\nError is : " + e.getStackTrace());
        }
        return returnedTrace;
    }

    public synchronized LTTngTrace clone() {
        LTTngTrace clone = null;
        try {
            clone = (LTTngTrace)super.clone();
            try {
                clone.currentJniTrace = JniTraceFactory.getJniTrace((String)this.getPath(), (String)this.getTraceLibPath(), (boolean)false);
            }
            catch (JniException jniException) {}
            clone.traceTypes = new HashMap();
            clone.traceTypeNames = new Vector();
            clone.initialiseEventTypes(clone.currentJniTrace);
            clone.eventTimestamp = new LttngTimestamp();
            clone.eventSource = new LttngEventSource();
            clone.eventType = new LttngEventType();
            clone.eventContent = new LttngEventContent(clone.currentLttngEvent);
            clone.eventReference = new LttngEventReference(this.getName());
            clone.currentLttngEvent = new LttngEvent(this, clone.eventTimestamp, clone.eventSource, clone.eventType, clone.eventContent, clone.eventReference, null);
            clone.previousLocation = new LttngLocation();
            clone.eventContent.setEvent(clone.currentLttngEvent);
            this.setTimeRange(new TmfTimeRange((TmfTimestamp)new LttngTimestamp(clone.currentJniTrace.getStartTime().getTime()), (TmfTimestamp)new LttngTimestamp(clone.currentJniTrace.getEndTime().getTime())));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        return clone;
    }

    public String getTraceLibPath() {
        return this.traceLibPath;
    }

    private void initialiseEventTypes(JniTrace trace) {
        LttngEventType tmpType = null;
        String[] markerFieldsLabels = null;
        String newTracefileKey2 = null;
        Integer newMarkerKey2 = null;
        JniTracefile newTracefile = null;
        JniMarker newMarker = null;
        for (String newTracefileKey2 : trace.getTracefilesMap().keySet()) {
            newTracefile = (JniTracefile)trace.getTracefilesMap().get(newTracefileKey2);
            for (Integer newMarkerKey2 : newTracefile.getTracefileMarkersMap().keySet()) {
                newMarker = (JniMarker)newTracefile.getTracefileMarkersMap().get(newMarkerKey2);
                markerFieldsLabels = newMarker.getMarkerFieldsHashMap().keySet().toArray(new String[newMarker.getMarkerFieldsHashMap().size()]);
                tmpType = new LttngEventType(newTracefile.getTracefileName(), newTracefile.getCpuNumber(), newMarker.getName(), newMarkerKey2, markerFieldsLabels);
                this.addEventTypeToMap(tmpType);
            }
        }
    }

    private void addEventTypeToMap(LttngEventType newEventType) {
        int newTypeKey = EventTypeKey.getEventTypeHash(newEventType);
        this.traceTypes.put(newTypeKey, newEventType);
        this.traceTypeNames.add(newTypeKey);
    }

    public synchronized ITmfLocation<?> getCurrentLocation() {
        return this.previousLocation;
    }

    public synchronized TmfContext seekLocation(ITmfLocation<?> location) {
        if (PrintDebug) {
            System.out.println("seekLocation(location) location -> " + location);
        }
        LttngLocation curLocation = null;
        if (location == null) {
            curLocation = new LttngLocation();
            TmfContext context = this.seekEvent(curLocation.getOperationTime());
            context.setRank(-1L);
            return context;
        }
        curLocation = (LttngLocation)location;
        TmfContext context = this.seekEvent(curLocation.getOperationTime());
        return context;
    }

    public synchronized TmfContext seekEvent(TmfTimestamp timestamp) {
        if (PrintDebug) {
            System.out.println("seekEvent(timestamp) timestamp -> " + timestamp);
        }
        if (this.currentJniTrace == null) {
            System.out.println("aie");
        }
        this.currentJniTrace.seekToTime(new JniTime(timestamp.getValue()));
        this.previousLocation.setOperationTime(timestamp.getValue());
        this.previousLocation.setLastOperationSeek();
        LttngLocation curLocation = new LttngLocation(this.previousLocation);
        return new TmfContext((ITmfLocation)curLocation);
    }

    public synchronized TmfContext seekEvent(long position) {
        if (PrintDebug) {
            System.out.println("seekEvent(position) position -> " + position);
        }
        TmfTimestamp timestamp = null;
        long index = position / (long)this.getCacheSize();
        if (this.fCheckpoints.size() > 0) {
            if (index >= (long)this.fCheckpoints.size()) {
                index = this.fCheckpoints.size() - 1;
            }
            timestamp = ((TmfCheckpoint)this.fCheckpoints.elementAt((int)index)).getTimestamp();
        } else {
            timestamp = this.getStartTime();
        }
        TmfContext tmpContext = this.seekEvent(timestamp);
        tmpContext.setRank((index + 1L) * (long)this.fIndexPageSize);
        this.previousLocation = (LttngLocation)tmpContext.getLocation();
        Long currentPosition = index * (long)this.getCacheSize();
        Long lastTimeValueRead = 0L;
        JniEvent tmpJniEvent = this.currentJniTrace.findNextEvent();
        while (tmpJniEvent != null && currentPosition < position) {
            tmpJniEvent = this.currentJniTrace.readNextEvent();
            currentPosition = currentPosition + 1L;
        }
        if (tmpJniEvent != null) {
            lastTimeValueRead = tmpJniEvent.getEventTime().getTime();
        }
        this.previousLocation.setLastOperationSeek();
        this.previousLocation.setOperationTime(lastTimeValueRead);
        LttngLocation curLocation = new LttngLocation(this.previousLocation);
        return new TmfContext((ITmfLocation)curLocation);
    }

    public TmfContext seekLocation(double ratio) {
        return null;
    }

    public double getLocationRatio(ITmfLocation<?> location) {
        return 0.0;
    }

    public synchronized LttngEvent getNextEvent(TmfContext context) {
        if (PrintDebug) {
            System.out.println("getNextEvent(context) context.getLocation() -> " + context.getLocation());
        }
        LttngEvent returnedEvent = null;
        LttngLocation curLocation = null;
        curLocation = (LttngLocation)context.getLocation();
        if (curLocation == null) {
            curLocation = this.getCurrentLocation(context);
        }
        if (!curLocation.isLastOperationParse() || this.previousLocation.getOperationTimeValue() != curLocation.getOperationTimeValue()) {
            if (this.previousLocation.getOperationTimeValue() != curLocation.getOperationTimeValue()) {
                if (PrintDebug) {
                    System.out.println("\t\tSeeking in getNextEvent. [ LastTime : " + this.previousLocation.getOperationTimeValue() + " CurrentTime" + curLocation.getOperationTimeValue() + " ]");
                }
                this.seekEvent(curLocation.getOperationTime());
            }
            returnedEvent = this.readNextEvent(curLocation);
        } else {
            returnedEvent = this.currentLttngEvent;
            this.previousLocation.resetLocationState();
            curLocation.resetLocationState();
        }
        if (returnedEvent != null) {
            this.setPreviousAndCurrentTimes(context, returnedEvent, curLocation);
        }
        return returnedEvent;
    }

    private void setPreviousAndCurrentTimes(TmfContext context, LttngEvent returnedEvent, LttngLocation curLocation) {
        TmfTimestamp eventTimestamp = returnedEvent.getTimestamp();
        this.previousLocation.setOperationTime(eventTimestamp.getValue());
        curLocation.setOperationTime(eventTimestamp.getValue());
        this.updateIndex(context, context.getRank(), eventTimestamp);
        context.updateRank(1);
    }

    protected void updateIndex(TmfContext context, long rank, TmfTimestamp timestamp) {
        if (this.getStartTime().compareTo(timestamp, false) > 0) {
            this.setStartTime(timestamp);
        }
        if (this.getEndTime().compareTo(timestamp, false) < 0) {
            this.setEndTime(timestamp);
        }
        if (rank != -2L) {
            if (this.fNbEvents <= rank) {
                this.fNbEvents = rank + 1L;
            }
            if (rank % (long)this.fIndexPageSize == 0L) {
                long position = rank / (long)this.fIndexPageSize;
                if ((long)this.fCheckpoints.size() == position) {
                    this.addCheckPoint(context, timestamp);
                }
            }
        }
    }

    private void addCheckPoint(TmfContext context, TmfTimestamp timestamp) {
        ITmfLocation location = context.getLocation().clone();
        this.fCheckpoints.add(new TmfCheckpoint(timestamp.clone(), location));
    }

    private LttngEvent readNextEvent(LttngLocation curLocation) {
        LttngEvent returnedEvent = this.readEvent(curLocation);
        ++this.nbEventsRead;
        this.previousLocation.setLastOperationReadNext();
        curLocation.setLastOperationReadNext();
        return returnedEvent;
    }

    private LttngLocation getCurrentLocation(TmfContext context) {
        LttngLocation curLocation = new LttngLocation();
        context.setLocation((ITmfLocation)curLocation);
        return curLocation;
    }

    public synchronized LttngEvent parseEvent(TmfContext context) {
        if (PrintDebug) {
            System.out.println("parseEvent(context) context.getLocation() -> " + context.getLocation());
        }
        LttngEvent returnedEvent = null;
        LttngLocation curLocation = null;
        if (context.getLocation() == null) {
            curLocation = new LttngLocation();
            context.setLocation((ITmfLocation)curLocation);
        } else {
            curLocation = (LttngLocation)context.getLocation();
        }
        if (!curLocation.isLastOperationParse() && !curLocation.isLastOperationReadNext() || this.previousLocation.getOperationTimeValue() != curLocation.getOperationTimeValue()) {
            if (this.previousLocation.getOperationTimeValue() != curLocation.getOperationTimeValue()) {
                if (PrintDebug) {
                    System.out.println("\t\tSeeking in getNextEvent. [ LastTime : " + this.previousLocation.getOperationTimeValue() + " CurrentTime" + curLocation.getOperationTimeValue() + " ]");
                }
                this.seekEvent(curLocation.getOperationTime());
            }
            returnedEvent = this.readEvent(curLocation);
        } else {
            returnedEvent = this.currentLttngEvent;
        }
        if (returnedEvent != null) {
            this.previousLocation.setOperationTime((LttngTimestamp)returnedEvent.getTimestamp());
            curLocation.setOperationTime((LttngTimestamp)returnedEvent.getTimestamp());
        }
        this.previousLocation.setLastOperationParse();
        curLocation.setLastOperationParse();
        return returnedEvent;
    }

    private synchronized LttngEvent readEvent(LttngLocation location) {
        LttngEvent returnedEvent = null;
        JniEvent tmpEvent = null;
        tmpEvent = this.currentJniTrace.readNextEvent();
        if (tmpEvent != null) {
            returnedEvent = this.convertJniEventToTmf(tmpEvent);
            location.setOperationTime((LttngTimestamp)returnedEvent.getTimestamp());
        } else {
            location.setOperationTime(this.getEndTime().getValue() + 1L);
        }
        return returnedEvent;
    }

    public synchronized LttngEvent convertJniEventToTmf(JniEvent newEvent) {
        this.currentLttngEvent = this.convertJniEventToTmf(newEvent, IS_PARSING_NEEDED_DEFAULT);
        return this.currentLttngEvent;
    }

    public synchronized LttngEvent convertJniEventToTmf(JniEvent jniEvent, boolean isParsingNeeded) {
        if (UniqueEvent) {
            this.eventTimestamp.setValue(jniEvent.getEventTime().getTime());
            this.eventSource.setSourceId(jniEvent.requestEventSource());
            this.eventType = this.traceTypes.get(EventTypeKey.getEventTypeHash(jniEvent));
            this.eventReference.setValue(jniEvent.getParentTracefile().getTracefilePath());
            this.eventReference.setTracepath(this.getName());
            this.eventContent.emptyContent();
            this.currentLttngEvent.setType(this.eventType);
            this.currentLttngEvent.updateJniEventReference(jniEvent);
            if (isParsingNeeded) {
                this.eventContent.getFields();
            }
            return this.currentLttngEvent;
        }
        return this.convertJniEventToTmfMultipleEventEvilFix(jniEvent, isParsingNeeded);
    }

    private synchronized LttngEvent convertJniEventToTmfMultipleEventEvilFix(JniEvent jniEvent, boolean isParsingNeeded) {
        this.eventTimestamp = new LttngTimestamp(jniEvent.getEventTime().getTime());
        this.eventSource = new LttngEventSource(jniEvent.requestEventSource());
        this.eventReference = new LttngEventReference(jniEvent.getParentTracefile().getTracefilePath(), this.getName());
        this.eventType = new LttngEventType(this.traceTypes.get(EventTypeKey.getEventTypeHash(jniEvent)));
        this.eventContent = new LttngEventContent(this.currentLttngEvent);
        this.currentLttngEvent = new LttngEvent(this, this.eventTimestamp, this.eventSource, this.eventType, this.eventContent, this.eventReference, null);
        this.currentLttngEvent.updateJniEventReference(jniEvent);
        this.eventContent.setEvent(this.currentLttngEvent);
        if (isParsingNeeded) {
            this.eventContent.getFields();
        }
        return this.currentLttngEvent;
    }

    public JniTrace getCurrentJniTrace() {
        return this.currentJniTrace;
    }

    public synchronized LttngEvent getCurrentEvent() {
        return this.currentLttngEvent;
    }

    public short getVersionMajor() {
        if (this.currentJniTrace != null) {
            return this.currentJniTrace.getLttMajorVersion();
        }
        return -1;
    }

    public short getVersionMinor() {
        if (this.currentJniTrace != null) {
            return this.currentJniTrace.getLttMinorVersion();
        }
        return -1;
    }

    public int getCpuNumber() {
        if (this.currentJniTrace != null) {
            return this.currentJniTrace.getCpuNumber();
        }
        return -1;
    }

    public void printCheckpointsVector() {
        System.out.println("StartTime : " + this.getTimeRange().getStartTime().getValue());
        System.out.println("EndTime   : " + this.getTimeRange().getEndTime().getValue());
        int pos = 0;
        while (pos < this.fCheckpoints.size()) {
            System.out.print(String.valueOf(pos) + ": " + "\t");
            System.out.print(((TmfCheckpoint)this.fCheckpoints.get(pos)).getTimestamp() + "\t");
            System.out.println(((TmfCheckpoint)this.fCheckpoints.get(pos)).getLocation());
            ++pos;
        }
    }

    public synchronized void dispose() {
        if (this.currentJniTrace != null) {
            this.currentJniTrace.closeTrace();
        }
        super.dispose();
    }

    public String toString() {
        String returnedData = "";
        returnedData = String.valueOf(returnedData) + "Path :" + this.getPath() + " ";
        returnedData = String.valueOf(returnedData) + "Trace:" + this.currentJniTrace + " ";
        returnedData = String.valueOf(returnedData) + "Event:" + (Object)((Object)this.currentLttngEvent);
        return returnedData;
    }
}

