/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.callgraph.graphlisteners;

import org.eclipse.linuxtools.callgraph.StapGraph;
import org.eclipse.linuxtools.callgraph.graphlisteners.AutoScrollHelper;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseWheelListener;

public class StapGraphMouseWheelListener
implements MouseWheelListener {
    private StapGraph graph;

    public StapGraphMouseWheelListener(StapGraph g) {
        this.graph = g;
    }

    public void mouseScrolled(MouseEvent e) {
        if (e.stateMask != 262144) {
            if (e.count > 0) {
                AutoScrollHelper.scrollUp(this.graph);
            } else {
                AutoScrollHelper.scrollDown(this.graph);
            }
            return;
        }
        if (this.graph.getDrawMode() != 0 && this.graph.getDrawMode() != 2) {
            return;
        }
        this.graph.scale = e.count <= 0 ? (this.graph.scale < 2.0 ? (this.graph.scale /= 0.9090909090909091) : (double)((int)this.graph.scale + 1)) : (this.graph.scale <= 2.0 ? (this.graph.scale *= 0.9090909090909091) : (double)((int)this.graph.scale - 1));
        int currentAnimationMode = this.graph.getAnimationMode();
        this.graph.draw(this.graph.getDrawMode(), 3, this.graph.getRootVisibleNodeNumber());
        this.graph.setAnimationMode(currentAnimationMode);
        int realeX = 3 * (int)((double)e.x / this.graph.scale);
        int realeY = 3 * (int)((double)e.y / this.graph.scale);
        int xDiff = realeX - this.graph.getSize().x;
        int yDiff = realeY - this.graph.getSize().y;
        this.graph.scrollTo(realeX + xDiff, realeY - yDiff);
    }
}

