/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.core.state.evProcessor;

import java.util.Set;
import org.eclipse.linuxtools.lttng.core.TraceDebug;
import org.eclipse.linuxtools.lttng.core.event.LttngEvent;
import org.eclipse.linuxtools.lttng.core.event.LttngSyntheticEvent;
import org.eclipse.linuxtools.lttng.core.state.evProcessor.IEventToHandlerResolver;
import org.eclipse.linuxtools.lttng.core.state.evProcessor.ILttngEventProcessor;
import org.eclipse.linuxtools.lttng.core.state.evProcessor.ITransEventProcessor;
import org.eclipse.linuxtools.lttng.core.state.model.LttngTraceState;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;

public abstract class AbsEventToHandlerResolver
implements IEventToHandlerResolver,
ITransEventProcessor {
    Long fbeforeEventCount = 0L;
    Long fstateUpdateCount = 0L;
    Long filteredOutEventsCount = 0L;

    @Override
    public abstract ILttngEventProcessor getBeforeProcessor(String var1);

    @Override
    public abstract ILttngEventProcessor getAfterProcessor(String var1);

    @Override
    public abstract ILttngEventProcessor getfinishProcessor();

    @Override
    public abstract ILttngEventProcessor getStateUpdaterProcessor(String var1);

    @Override
    public boolean process(LttngEvent trcEvent, LttngTraceState traceSt) {
        if (trcEvent instanceof LttngSyntheticEvent) {
            LttngSyntheticEvent synEvent = (LttngSyntheticEvent)trcEvent;
            ILttngEventProcessor processor = null;
            String eventType = synEvent.getMarkerName();
            switch (synEvent.getSynType()) {
                case STARTREQ: {
                    this.reset();
                    return false;
                }
                case BEFORE: {
                    processor = this.getBeforeProcessor(eventType);
                    this.incrementBeforeEventCount();
                    break;
                }
                case UPDATE: {
                    processor = this.getStateUpdaterProcessor(eventType);
                    this.incrementStateUpdateCount();
                    break;
                }
                case AFTER: {
                    processor = this.getAfterProcessor(eventType);
                    break;
                }
                case ENDREQ: {
                    processor = this.getfinishProcessor();
                    TraceDebug.debug("EndRequest satus received:");
                    break;
                }
            }
            if (processor != null) {
                processor.process(trcEvent, traceSt);
            }
        }
        return true;
    }

    @Override
    public void process(TmfEvent tmfEvent, LttngTraceState traceSt) {
        if (tmfEvent == null) {
            return;
        }
        if (!(tmfEvent instanceof LttngSyntheticEvent)) {
            TraceDebug.debug("The event received is not an instance of LttngSyntheticEvent and can not be processed");
            return;
        }
        LttngSyntheticEvent trcEvent = (LttngSyntheticEvent)tmfEvent;
        this.process(trcEvent, traceSt);
    }

    public Set<String> getEventsNotHandled() {
        return null;
    }

    @Override
    public Long getBeforeEventCount() {
        return this.fbeforeEventCount;
    }

    @Override
    public Long getStateUpdateCount() {
        return this.fstateUpdateCount;
    }

    @Override
    public Long getFilteredOutEventCount() {
        return this.filteredOutEventsCount;
    }

    protected void reset() {
        this.fbeforeEventCount = 0L;
        this.fstateUpdateCount = 0L;
        this.filteredOutEventsCount = 0L;
    }

    protected void incrementBeforeEventCount() {
        this.fbeforeEventCount = this.fbeforeEventCount + 1L;
    }

    protected void incrementStateUpdateCount() {
        this.fstateUpdateCount = this.fstateUpdateCount + 1L;
    }
}

