/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.core.configure;

import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.AbstractConfigurationOption;
import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.AutotoolsConfiguration;
import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.IConfigureOption;

public class BinConfigureOption
extends AbstractConfigurationOption {
    private boolean value;

    public BinConfigureOption(String name, AutotoolsConfiguration cfg) {
        super(name, cfg);
    }

    public BinConfigureOption(String name, String msgName, AutotoolsConfiguration cfg) {
        super(name, msgName, cfg);
    }

    private BinConfigureOption(String name, AutotoolsConfiguration cfg, boolean value) {
        super(name, cfg);
        this.value = value;
    }

    public boolean isParmSet() {
        return this.value;
    }

    public String getParameter() {
        if (this.isParmSet()) {
            return this.getParameterName();
        }
        return "";
    }

    public String getValue() {
        return Boolean.toString(this.value);
    }

    public void setValue(String value) {
        boolean oldValue = this.value;
        this.value = value.equals("true");
        if (this.value != oldValue) {
            this.cfg.setDirty(true);
        }
    }

    public IConfigureOption copy(AutotoolsConfiguration config) {
        return new BinConfigureOption(this.name, config, this.value);
    }

    public int getType() {
        return 1;
    }
}

