/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.core.configure;

import java.util.ArrayList;
import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.AutotoolsConfiguration;
import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.ConfigureMessages;
import org.eclipse.linuxtools.internal.cdt.autotools.core.configure.IConfigureOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigurationOption
implements IConfigureOption {
    protected String name;
    private String msgName;
    protected AutotoolsConfiguration cfg;

    public AbstractConfigurationOption(String name, AutotoolsConfiguration cfg) {
        this(name, name, cfg);
    }

    public AbstractConfigurationOption(String name, String msgName, AutotoolsConfiguration cfg) {
        this.name = name;
        this.msgName = msgName;
        this.cfg = cfg;
    }

    @Override
    public String getDescription() {
        return ConfigureMessages.getConfigureDescription(this.msgName);
    }

    @Override
    public String getToolTip() {
        return ConfigureMessages.getConfigureTip(this.msgName);
    }

    public String getMsgName() {
        return this.msgName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public AutotoolsConfiguration getCfg() {
        return this.cfg;
    }

    @Override
    public ArrayList<String> getParameters() {
        ArrayList<String> parameters = new ArrayList<String>();
        if (this.isParmSet()) {
            parameters.add(this.getParameter());
        }
        return parameters;
    }

    public String getParameterName() {
        return "--" + this.getName();
    }

    @Override
    public boolean isCategory() {
        return false;
    }

    @Override
    public boolean isFlag() {
        return false;
    }

    @Override
    public boolean isFlagValue() {
        return false;
    }

    @Override
    public boolean isMultiArg() {
        return false;
    }
}

