/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.wireadmin;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.osgi.service.wireadmin.WirePermission;

final class WirePermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = 2617521094909826016L;
    private Hashtable permissions = new Hashtable();
    private boolean all_allowed = false;

    public void add(Permission permission) {
        if (!(permission instanceof WirePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        WirePermission p = (WirePermission)permission;
        String name = p.getName();
        WirePermission existing = (WirePermission)this.permissions.get(name);
        if (existing != null) {
            int newMask;
            int oldMask = existing.getMask();
            if (oldMask != (newMask = p.getMask())) {
                this.permissions.put(name, new WirePermission(name, oldMask | newMask));
            }
        } else {
            this.permissions.put(name, permission);
        }
        if (!this.all_allowed && name.equals("*")) {
            this.all_allowed = true;
        }
    }

    public boolean implies(Permission permission) {
        int last;
        WirePermission x;
        if (!(permission instanceof WirePermission)) {
            return false;
        }
        WirePermission p = (WirePermission)permission;
        int desired = p.getMask();
        int effective = 0;
        if (this.all_allowed && (x = (WirePermission)this.permissions.get("*")) != null && ((effective |= x.getMask()) & desired) == desired) {
            return true;
        }
        String name = p.getName();
        x = (WirePermission)this.permissions.get(name);
        if (x != null && ((effective |= x.getMask()) & desired) == desired) {
            return true;
        }
        int offset = name.length() - 1;
        while ((last = name.lastIndexOf(".", offset)) != -1) {
            x = (WirePermission)this.permissions.get(name = name.substring(0, last + 1) + "*");
            if (x != null && ((effective |= x.getMask()) & desired) == desired) {
                return true;
            }
            offset = last - 1;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

