/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.breakpoints;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.debug.core.model.ICWatchpoint2;
import org.eclipse.cdt.debug.internal.core.breakpoints.BreakpointMessages;
import org.eclipse.cdt.debug.internal.core.breakpoints.CBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class CWatchpoint
extends CBreakpoint
implements ICWatchpoint2 {
    public CWatchpoint() {
    }

    public CWatchpoint(IResource resource, Map<String, Object> attributes, boolean add) throws CoreException {
        super(resource, attributes, add);
    }

    @Override
    public String getMarkerType() {
        return "org.eclipse.cdt.debug.core.cWatchpointMarker";
    }

    @Override
    public boolean isWriteType() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.write", true);
    }

    @Override
    public boolean isReadType() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.read", false);
    }

    @Override
    public String getExpression() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.expression", "");
    }

    @Override
    protected String getMarkerMessage() throws CoreException {
        String format = BreakpointMessages.getString("CWatchpoint.3");
        if (this.isWriteType() && !this.isReadType()) {
            format = BreakpointMessages.getString("CWatchpoint.0");
        } else if (!this.isWriteType() && this.isReadType()) {
            format = BreakpointMessages.getString("CWatchpoint.1");
        } else if (this.isWriteType() && this.isReadType()) {
            format = BreakpointMessages.getString("CWatchpoint.2");
        }
        return MessageFormat.format(format, CDebugUtils.getBreakpointText(this, false));
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    @Override
    public String getMemorySpace() throws CoreException {
        return this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.memoryspace", "");
    }

    @Override
    public BigInteger getRange() throws CoreException {
        String attr = this.ensureMarker().getAttribute("org.eclipse.cdt.debug.core.range", "0");
        return new BigInteger(attr.length() > 0 ? attr : "0");
    }
}

