/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.views.annotations;

import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.taginfo.MarkupTagInfoProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLAnnotationsView
extends ViewPart
implements ISelectionListener {
    public static final String ID = "org.eclipse.wst.xml.ui.view.annotations.XMLAnnotationsView";
    private StyledText styledtext;
    private String xmlDoc = XMLUIMessages.Documentation_view_default_msg;
    private HTMLTextPresenter presenter;
    private final TextPresentation presentation = new TextPresentation();
    private IStructuredSelection currentSelection;
    private CMNode cmNode;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this);
    }

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.presenter = new HTMLTextPresenter(false);
        this.createStyledTextWidget(container);
        this.doStyledTextInput();
    }

    private void createStyledTextWidget(Composite container) {
        this.styledtext = new StyledText(container, 768);
        this.styledtext.setBackground(this.getColor(29));
        this.styledtext.setEditable(false);
        this.styledtext.setBounds(container.getBounds());
        this.styledtext.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                XMLAnnotationsView.this.doStyledTextInput();
            }
        });
    }

    private void doStyledTextInput() {
        String msg;
        this.presentation.clear();
        Rectangle size = this.styledtext.getClientArea();
        int width = size.width;
        int height = size.height;
        if (width == 0) {
            width = 200;
        }
        if (height == 0) {
            height = 400;
        }
        if ((msg = this.presenter.updatePresentation((Drawable)this.styledtext, this.xmlDoc, this.presentation, width, height)) != null) {
            this.styledtext.setText(msg);
            TextPresentation.applyTextPresentation((TextPresentation)this.presentation, (StyledText)this.styledtext);
        }
    }

    public void setFocus() {
    }

    public void dispose() {
        this.styledtext = null;
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this);
        this.cmNode = null;
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IEditorPart edPart = this.getSite().getPage().getActiveEditor();
        if (part.equals(edPart) && selection instanceof IStructuredSelection) {
            this.currentSelection = (IStructuredSelection)selection;
            if (!selection.isEmpty() && this.currentSelection.getFirstElement() instanceof Node) {
                Node node = (Node)this.currentSelection.getFirstElement();
                ModelQuery mq = ModelQueryUtil.getModelQuery((Document)node.getOwnerDocument());
                if (mq != null) {
                    this.cmNode = mq.getCMNode(node);
                    MarkupTagInfoProvider tagInfo = new MarkupTagInfoProvider();
                    this.xmlDoc = tagInfo.getInfo(this.cmNode);
                } else {
                    this.xmlDoc = XMLUIMessages.Documentation_view_default_msg;
                }
                this.doStyledTextInput();
            }
        }
    }

    private Color getColor(int colorID) {
        Display display = Display.getCurrent();
        return display.getSystemColor(colorID);
    }
}

