/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.client.messages.swarm.ResourceSpec;

final class ImmutableResourceSpec {
    private ImmutableResourceSpec() {
    }

    static final class DiscreteResourceSpec
    implements ResourceSpec.DiscreteResourceSpec {
        private final String kind;
        private final int value;

        private DiscreteResourceSpec(String kind, int value) {
            this.kind = kind;
            this.value = value;
        }

        @Override
        @JsonProperty(value="Kind")
        public String kind() {
            return this.kind;
        }

        @Override
        @JsonProperty(value="Value")
        public int value() {
            return this.value;
        }

        public final DiscreteResourceSpec withKind(String value) {
            String newValue = Objects.requireNonNull(value, "kind");
            if (this.kind.equals(newValue)) {
                return this;
            }
            return new DiscreteResourceSpec(newValue, this.value);
        }

        public final DiscreteResourceSpec withValue(int value) {
            if (this.value == value) {
                return this;
            }
            return new DiscreteResourceSpec(this.kind, value);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof DiscreteResourceSpec && this.equalsByValue((DiscreteResourceSpec)another);
        }

        private boolean equalsByValue(DiscreteResourceSpec another) {
            return this.kind.equals(another.kind) && this.value == another.value;
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.kind.hashCode();
            h += (h << 5) + this.value;
            return h;
        }

        public String toString() {
            return "DiscreteResourceSpec{kind=" + this.kind + ", value=" + this.value + "}";
        }

        public static DiscreteResourceSpec copyOf(ResourceSpec.DiscreteResourceSpec instance) {
            if (instance instanceof DiscreteResourceSpec) {
                return (DiscreteResourceSpec)instance;
            }
            return DiscreteResourceSpec.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonTypeName(value="DiscreteResourceSpec")
        static final class Builder
        implements ResourceSpec.DiscreteResourceSpec.Builder {
            private static final long INIT_BIT_KIND = 1L;
            private static final long INIT_BIT_VALUE = 2L;
            private long initBits = 3L;
            private String kind;
            private int value;

            private Builder() {
            }

            public final Builder from(ResourceSpec instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(ResourceSpec.DiscreteResourceSpec instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                ResourceSpec instance;
                long bits = 0L;
                if (object instanceof ResourceSpec) {
                    instance = (ResourceSpec)object;
                    if ((bits & 1L) == 0L) {
                        this.kind(instance.kind());
                        bits |= 1L;
                    }
                }
                if (object instanceof ResourceSpec.DiscreteResourceSpec) {
                    instance = (ResourceSpec.DiscreteResourceSpec)object;
                    this.value(instance.value());
                    if ((bits & 1L) == 0L) {
                        this.kind(instance.kind());
                        bits |= 1L;
                    }
                }
            }

            @Override
            @JsonProperty(value="Kind")
            public final Builder kind(String kind) {
                this.kind = Objects.requireNonNull(kind, "kind");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @Override
            @JsonProperty(value="Value")
            public final Builder value(int value) {
                this.value = value;
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @Override
            public DiscreteResourceSpec build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new DiscreteResourceSpec(this.kind, this.value);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("kind");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build DiscreteResourceSpec, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }

    static final class NamedResourceSpec
    implements ResourceSpec.NamedResourceSpec {
        private final String kind;
        private final String value;

        private NamedResourceSpec(String kind, String value) {
            this.kind = kind;
            this.value = value;
        }

        @Override
        @JsonProperty(value="Kind")
        public String kind() {
            return this.kind;
        }

        @Override
        @JsonProperty(value="Value")
        public String value() {
            return this.value;
        }

        public final NamedResourceSpec withKind(String value) {
            String newValue = Objects.requireNonNull(value, "kind");
            if (this.kind.equals(newValue)) {
                return this;
            }
            return new NamedResourceSpec(newValue, this.value);
        }

        public final NamedResourceSpec withValue(String value) {
            String newValue = Objects.requireNonNull(value, "value");
            if (this.value.equals(newValue)) {
                return this;
            }
            return new NamedResourceSpec(this.kind, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof NamedResourceSpec && this.equalsByValue((NamedResourceSpec)another);
        }

        private boolean equalsByValue(NamedResourceSpec another) {
            return this.kind.equals(another.kind) && this.value.equals(another.value);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.kind.hashCode();
            h += (h << 5) + this.value.hashCode();
            return h;
        }

        public String toString() {
            return "NamedResourceSpec{kind=" + this.kind + ", value=" + this.value + "}";
        }

        public static NamedResourceSpec copyOf(ResourceSpec.NamedResourceSpec instance) {
            if (instance instanceof NamedResourceSpec) {
                return (NamedResourceSpec)instance;
            }
            return NamedResourceSpec.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @JsonTypeName(value="NamedResourceSpec")
        static final class Builder
        implements ResourceSpec.NamedResourceSpec.Builder {
            private static final long INIT_BIT_KIND = 1L;
            private static final long INIT_BIT_VALUE = 2L;
            private long initBits = 3L;
            private String kind;
            private String value;

            private Builder() {
            }

            public final Builder from(ResourceSpec instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            public final Builder from(ResourceSpec.NamedResourceSpec instance) {
                Objects.requireNonNull(instance, "instance");
                this.mergeInternal(instance);
                return this;
            }

            private void mergeInternal(Object object) {
                ResourceSpec instance;
                long bits = 0L;
                if (object instanceof ResourceSpec) {
                    instance = (ResourceSpec)object;
                    if ((bits & 1L) == 0L) {
                        this.kind(instance.kind());
                        bits |= 1L;
                    }
                }
                if (object instanceof ResourceSpec.NamedResourceSpec) {
                    instance = (ResourceSpec.NamedResourceSpec)object;
                    this.value(instance.value());
                    if ((bits & 1L) == 0L) {
                        this.kind(instance.kind());
                        bits |= 1L;
                    }
                }
            }

            @Override
            @JsonProperty(value="Kind")
            public final Builder kind(String kind) {
                this.kind = Objects.requireNonNull(kind, "kind");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @Override
            @JsonProperty(value="Value")
            public final Builder value(String value) {
                this.value = Objects.requireNonNull(value, "value");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @Override
            public NamedResourceSpec build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new NamedResourceSpec(this.kind, this.value);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("kind");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("value");
                }
                return "Cannot build NamedResourceSpec, some of required attributes are not set " + String.valueOf(attributes);
            }
        }
    }
}

