/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.egit.core.op.MergeOperation;
import org.eclipse.egit.ui.internal.actions.MergeActionHandler;
import org.eclipse.egit.ui.internal.branch.LaunchFinder;
import org.eclipse.egit.ui.internal.dialogs.BasicConfigurationDialog;
import org.eclipse.egit.ui.internal.dialogs.MergeTargetSelectionDialog;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public class MergeCommand
extends RepositoriesViewCommandHandler<RepositoryTreeNode> {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        MergeOperation op;
        String targetRef;
        String refName;
        Repository repository;
        block9: {
            RepositoryTreeNode node = (RepositoryTreeNode)this.getSelectedNodes(event).get(0);
            repository = node.getRepository();
            if (repository == null || !MergeActionHandler.checkMergeIsPossible(repository, this.getShell(event)) || LaunchFinder.shouldCancelBecauseOfRunningLaunches(repository, null)) {
                return null;
            }
            BasicConfigurationDialog.show(repository);
            if (node instanceof RefNode) {
                refName = ((Ref)((RefNode)node).getObject()).getName();
                try {
                    if (refName.equals(repository.getFullBranch())) {
                        targetRef = null;
                        break block9;
                    }
                    targetRef = refName;
                }
                catch (IOException e) {
                    targetRef = null;
                }
            } else {
                targetRef = node instanceof TagNode ? ((Ref)((TagNode)node).getObject()).getName() : null;
            }
        }
        if (targetRef != null) {
            refName = targetRef;
            op = new MergeOperation(repository, refName);
        } else {
            MergeTargetSelectionDialog mergeTargetSelectionDialog = new MergeTargetSelectionDialog(this.getShell(event), repository);
            if (mergeTargetSelectionDialog.open() != 0) {
                return null;
            }
            refName = mergeTargetSelectionDialog.getRefName();
            op = new MergeOperation(repository, refName);
            op.setSquash(mergeTargetSelectionDialog.isMergeSquash());
            op.setFastForwardMode(mergeTargetSelectionDialog.getFastForwardMode());
            op.setCommit(mergeTargetSelectionDialog.isCommit());
        }
        MergeActionHandler.doMerge(repository, op, refName);
        return null;
    }

    public boolean isEnabled() {
        return this.selectedRepositoryHasHead();
    }
}

