/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.pr;

import java.text.MessageFormat;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.mylyn.internal.github.ui.pr.Messages;
import org.eclipse.mylyn.internal.github.ui.pr.PullRequestRepositoryQueryPage;
import org.eclipse.mylyn.internal.github.ui.pr.PullRequestRepositorySettingsPage;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.wizards.ITaskRepositoryPage;
import org.eclipse.mylyn.tasks.ui.wizards.NewTaskWizard;
import org.eclipse.mylyn.tasks.ui.wizards.RepositoryQueryWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class PullRequestConnectorUi
extends AbstractRepositoryConnectorUi {
    public static void showNoRepositoryDialog(PullRequest request) {
        Repository remoteRepo = request.getBase().getRepo();
        String id = remoteRepo.getOwner().getLogin() + "/" + remoteRepo.getName();
        String message = MessageFormat.format(Messages.PullRequestConnectorUi_MessageRepositoryNotFound, id);
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.PullRequestConnectorUi_TitleRepositoryNotFound, (String)message));
    }

    public String getConnectorKind() {
        return "githubPullRequests";
    }

    public ITaskRepositoryPage getSettingsPage(TaskRepository taskRepository) {
        return new PullRequestRepositorySettingsPage(taskRepository);
    }

    public IWizard getQueryWizard(TaskRepository taskRepository, IRepositoryQuery queryToEdit) {
        RepositoryQueryWizard wizard = new RepositoryQueryWizard(taskRepository);
        PullRequestRepositoryQueryPage queryPage = new PullRequestRepositoryQueryPage(taskRepository, queryToEdit);
        wizard.addPage((IWizardPage)queryPage);
        return wizard;
    }

    public IWizard getNewTaskWizard(TaskRepository taskRepository, ITaskMapping selection) {
        return new NewTaskWizard(taskRepository, selection);
    }

    public boolean hasSearchPage() {
        return true;
    }

    public String getTaskKindLabel(ITask task) {
        return Messages.PullRequestConnectorUi_LabelKind;
    }
}

