/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.typing;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.internal.Logger;

public abstract class AbstractCharacterPairInserter {
    public boolean pair(ISourceViewer viewer, char c) {
        if (!this.shouldPair(viewer, c)) {
            return false;
        }
        char mc = this.getPair(c);
        char[] chars = new char[]{c, mc};
        IDocument document = viewer.getDocument();
        Point selection = viewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        boolean paired = false;
        try {
            document.replace(offset, length, new String(chars));
            LinkedModeModel model = new LinkedModeModel();
            LinkedPositionGroup group = new LinkedPositionGroup();
            group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
            model.addGroup(group);
            model.forceInstall();
            LinkedModeUI ui = new LinkedModeUI(model, (ITextViewer)viewer);
            ui.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
            ui.setExitPosition((ITextViewer)viewer, offset + 2, 0, Integer.MAX_VALUE);
            ui.setExitPolicy(this.getExitPolicy(mc, this.getEscapeChar(c), document));
            ui.setSimpleMode(true);
            ui.enter();
            paired = true;
        }
        catch (BadLocationException e) {
            Logger.logException(e);
        }
        return paired;
    }

    protected boolean shouldPair(ISourceViewer viewer, char c) {
        return true;
    }

    public abstract boolean hasPair(char var1);

    protected abstract char getPair(char var1);

    protected char getEscapeChar(char c) {
        return '\u0000';
    }

    public void initialize() {
    }

    public void dispose() {
    }

    protected LinkedModeUI.IExitPolicy getExitPolicy(char exit, char escape, IDocument document) {
        return new ExitPolicy(exit, escape, document);
    }

    class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private char fExit;
        private char fEscape;
        private IDocument fDocument;

        public ExitPolicy(char exit, char escape, IDocument document) {
            this.fExit = exit;
            this.fEscape = escape;
            this.fDocument = document;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (!this.isMasked(offset) && event.character == this.fExit) {
                return new LinkedModeUI.ExitFlags(2, false);
            }
            return null;
        }

        private boolean isMasked(int offset) {
            try {
                return this.fEscape == this.fDocument.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }
}

