/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdge;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfEdgeContextState;
import org.eclipse.tracecompass.analysis.graph.core.graph.ITmfVertex;
import org.eclipse.tracecompass.internal.analysis.graph.core.graph.historytree.TmfVertex;

public class TmfEdge
implements ITmfEdge {
    private final TmfVertex fVertexFrom;
    private final TmfVertex fVertexTo;
    private final ITmfEdgeContextState fContextState;
    private final @Nullable String fQualifier;

    public TmfEdge(TmfVertex from, TmfVertex to, ITmfEdgeContextState contextState) {
        this(from, to, contextState, null);
    }

    public TmfEdge(TmfVertex from, TmfVertex to, ITmfEdgeContextState contextState, @Nullable String qualifier) {
        this.fVertexFrom = from;
        this.fVertexTo = to;
        this.fContextState = contextState;
        this.fQualifier = qualifier;
    }

    @Override
    public ITmfVertex getVertexFrom() {
        return this.fVertexFrom;
    }

    @Override
    public ITmfVertex getVertexTo() {
        return this.fVertexTo;
    }

    @Override
    public ITmfEdgeContextState getEdgeContextState() {
        return this.fContextState;
    }

    @Override
    public @Nullable String getLinkQualifier() {
        return this.fQualifier;
    }

    @Override
    public long getDuration() {
        return this.fVertexTo.getTimestamp() - this.fVertexFrom.getTimestamp();
    }

    public String toString() {
        return "[" + String.valueOf(this.fVertexFrom) + "--" + String.valueOf(this.fContextState.getContextEnum()) + "->" + String.valueOf(this.fVertexTo) + "]";
    }
}

