/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.breakpoints;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.model.LineBreakpoint;
import org.eclipse.jdt.annotation.Nullable;

public class DSPLineBreakpoint
extends LineBreakpoint {
    public static final String ID = "org.eclipse.lsp4e.debug.breakpoints.markerType.lineBreakpoint";
    public static final String ATTR_CONDITION = "org.eclipse.lsp4e.debug.breakpoints.condition";
    public static final String ATTR_COLUMN = "org.eclipse.lsp4e.debug.breakpoints.column";
    public static final String ATTR_HIT_CONDITION = "org.eclipse.lsp4e.debug.breakpoints.hitCondition";

    public DSPLineBreakpoint() {
    }

    public DSPLineBreakpoint(IResource resource, int lineNumber) throws CoreException {
        this.run(this.getMarkerRule(resource), monitor -> {
            IMarker marker = resource.createMarker(ID);
            this.setMarker(marker);
            marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
            marker.setAttribute("lineNumber", lineNumber);
            marker.setAttribute("org.eclipse.debug.core.id", (Object)this.getModelIdentifier());
            marker.setAttribute("message", (Object)(resource.getName() + " [line: " + lineNumber + "]"));
        });
    }

    public DSPLineBreakpoint(IResource resource, String fileName, int lineNumber) throws CoreException {
        this.run(this.getMarkerRule(resource), monitor -> {
            IMarker marker = resource.createMarker(ID);
            this.setMarker(marker);
            marker.setAttribute("org.eclipse.debug.core.enabled", (Object)Boolean.TRUE);
            marker.setAttribute("lineNumber", lineNumber);
            marker.setAttribute("org.eclipse.debug.core.id", (Object)this.getModelIdentifier());
            marker.setAttribute("message", (Object)(resource.getName() + " [line: " + lineNumber + "]"));
        });
    }

    public String getModelIdentifier() {
        return "org.eclipse.lsp4e.debug.model";
    }

    public int getColumn() {
        IMarker m = this.getMarker();
        return m == null ? -1 : m.getAttribute(ATTR_COLUMN, -1);
    }

    public void setColumn(int column) throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            m.setAttribute(ATTR_COLUMN, (Object)(column <= 0 ? null : Integer.valueOf(column)));
        }
    }

    public @Nullable String getCondition() {
        IMarker m = this.getMarker();
        return m == null ? null : m.getAttribute(ATTR_CONDITION, null);
    }

    public void setCondition(@Nullable String condition) throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            m.setAttribute(ATTR_CONDITION, condition == null || condition.isBlank() ? null : condition);
        }
    }

    public @Nullable String getHitCondition() {
        IMarker m = this.getMarker();
        return m == null ? null : m.getAttribute(ATTR_HIT_CONDITION, null);
    }

    public void setHitCondition(@Nullable String hitCondition) throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            m.setAttribute(ATTR_HIT_CONDITION, hitCondition == null || hitCondition.isBlank() ? null : hitCondition);
        }
    }
}

