/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.flash.proxy;

import org.eclipse.actf.model.internal.flash.proxy.ProxyPlugin;
import org.eclipse.actf.model.internal.flash.proxy.ui.CacheClearDialog;
import org.eclipse.actf.model.internal.flash.proxy.ui.actions.DeleteCacheAction;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FlashCacheUtil {
    public static boolean cacheChecked = false;

    public static void checkCache() {
        ProxyPlugin proxyPlugin = ProxyPlugin.getDefault();
        IPreferenceStore preferenceStore = proxyPlugin.getPreferenceStore();
        String setting = preferenceStore.getString("CacheClearMode");
        boolean clearCacheFlag = !cacheChecked;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell shell = window.getShell();
        if (setting.equals("CONFIRM_WHEN_STARTUP") && !cacheChecked) {
            CacheClearDialog dialog = null;
            dialog = new CacheClearDialog(shell, Platform.getProduct().getName());
            try {
                dialog.open();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String select = dialog.getSelection();
            if (select.equals("CACHE_CLEAR_WHEN_STARTUP_AND_CACHE_CLEAR")) {
                preferenceStore.setValue("CacheClearMode", "CACHE_CLEAR_WHEN_STARTUP");
            } else if (select.equals("CONFIRM_AND_CACHE_CLEAR")) {
                preferenceStore.setValue("CacheClearMode", "CONFIRM_WHEN_STARTUP");
            } else if (select.equals("CONFIRM_AND_NO_OPERATION")) {
                preferenceStore.setValue("CacheClearMode", "CONFIRM_WHEN_STARTUP");
                clearCacheFlag = false;
            }
        } else if (setting.equals("CACHE_CLEAR_WHEN_STARTUP") && cacheChecked) {
            clearCacheFlag = false;
        } else if (setting.equals("NO_CACHE_CLEAR")) {
            clearCacheFlag = false;
        }
        if (clearCacheFlag) {
            FlashCacheUtil.clearCache(false, window);
        }
    }

    public static void clearCacheForStartup() {
        String setting = ProxyPlugin.getDefault().getPreferenceStore().getString("CacheClearMode");
        if (setting.equals("CACHE_CLEAR_WHEN_STARTUP")) {
            FlashCacheUtil.clearCache(false, null);
        }
    }

    public static void clearCache(boolean background, IWorkbenchWindow window) {
        DeleteCacheAction dca = new DeleteCacheAction(background);
        dca.init(window);
        dca.run(null);
    }
}

