/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ui.util;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

public class HighlightStringListener
implements LineStyleListener {
    private Vector<HighlightInfo> highlightInfoV = new Vector();

    public void addTarget(String target, Color fgcolor) {
        HighlightInfo hi = new HighlightInfo(target, fgcolor);
        this.highlightInfoV.add(hi);
    }

    public void addTarget(String target, Color fgcolor, int style) {
        HighlightInfo hi = new HighlightInfo(target, fgcolor);
        hi.setStyle(style);
        this.highlightInfoV.add(hi);
    }

    public void lineGetStyle(LineStyleEvent arg0) {
        String text = arg0.lineText;
        int lastIndex = 0;
        int index = 0;
        ArrayList<StyleRange> styles = new ArrayList<StyleRange>();
        for (HighlightInfo hi : this.highlightInfoV) {
            String target = hi.getTargetS();
            while ((index = text.indexOf(target, lastIndex)) != -1) {
                StyleRange range = new StyleRange();
                range.start = arg0.lineOffset + index;
                range.length = target.length();
                range.foreground = hi.getFgColor();
                range.background = hi.getBgColor();
                range.fontStyle = hi.getStyle();
                styles.add(range);
                lastIndex = index + target.length();
            }
        }
        arg0.styles = styles.toArray(new StyleRange[styles.size()]);
    }

    private class HighlightInfo {
        String targetS;
        Color fgColor;
        Color bgColor;
        int style;

        public HighlightInfo(String targetS, Color fgColor) {
            this(targetS, fgColor, null, 0);
        }

        public HighlightInfo(String targetS, Color fgColor, Color bgColor, int style) {
            this.targetS = targetS;
            this.fgColor = fgColor;
            this.bgColor = bgColor;
            this.style = style;
        }

        public Color getBgColor() {
            return this.bgColor;
        }

        public void setBgColor(Color bgColor) {
            this.bgColor = bgColor;
        }

        public Color getFgColor() {
            return this.fgColor;
        }

        public void setFgColor(Color fgColor) {
            this.fgColor = fgColor;
        }

        public int getStyle() {
            return this.style;
        }

        public void setStyle(int style) {
            this.style = style;
        }

        public String getTargetS() {
            return this.targetS;
        }

        public void setTargetS(String targetS) {
            this.targetS = targetS;
        }
    }
}

