/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.modelgroup;

import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.CompositeModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.IModelGroup;
import org.w3c.dom.Node;

public class OrModelGroup
extends CompositeModelGroup {
    public OrModelGroup(IModelGroup modelGroup) {
        super(modelGroup);
        if (modelGroup instanceof OrModelGroup) {
            OrModelGroup orMG = (OrModelGroup)modelGroup;
            this.childLength = orMG.childLength;
            int i = 0;
            while (i < this.childLength) {
                this.children[i] = orMG.children[i];
                ++i;
            }
        }
    }

    public void add(IModelGroup modelGroup) {
        if (modelGroup instanceof OrModelGroup) {
            OrModelGroup orModelGroup = (OrModelGroup)modelGroup;
            int i = 0;
            while (i < orModelGroup.childLength) {
                this.children[this.childLength++] = orModelGroup.children[i];
                ++i;
            }
        } else {
            this.children[this.childLength++] = modelGroup;
        }
    }

    public ElementDefinition[] getChildren() throws ParseException {
        ElementDefinition[] ret = new ElementDefinition[this.childLength];
        int i = 0;
        while (i < this.childLength) {
            ret[i] = (ElementDefinition)this.children[i];
            ++i;
        }
        return ret;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("(");
        int i = 0;
        while (i < this.childLength - 1) {
            ret.append(this.children[i]);
            ret.append('|');
            ++i;
        }
        ret.append(this.children[this.childLength - 1]);
        ret.append(")");
        return ret.toString();
    }

    public boolean match(ISGMLParser parser, Node parent, Node child) {
        int i = 0;
        while (i < this.childLength) {
            if (this.children[i].match(parser, parent, child)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean optional() {
        int i = this.childLength - 1;
        while (i >= 0) {
            if (this.children[i].optional()) {
                return true;
            }
            --i;
        }
        return false;
    }
}

