/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.html.errorhandler;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.actf.model.dom.html.IErrorHandler;
import org.eclipse.actf.model.dom.html.IParser;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.impl.ElementDefinition;
import org.eclipse.actf.model.internal.dom.sgml.impl.EndTag;
import org.eclipse.actf.model.internal.dom.sgml.impl.SGMLText;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class HTMLErrorHandler
implements IErrorHandler {
    private boolean keepForm = true;

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean handleError(int code, IParser parser, Node errorNode) throws ParseException, IOException, SAXException {
        if (code == 4) {
            return false;
        }
        String nodeName = errorNode.getNodeName();
        Element context = parser.getContext();
        Node contextParent = context.getParentNode();
        String contextName = context.getNodeName();
        if (errorNode instanceof Element) {
            ElementDefinition ed = ((ISGMLParser)parser).getDTD().getElementDefinition(nodeName);
            if (ed == null) {
                return false;
            }
            if (nodeName.equalsIgnoreCase("LINK") || nodeName.equalsIgnoreCase("STYLE") || nodeName.equalsIgnoreCase("META") || nodeName.equalsIgnoreCase("BASE") || nodeName.equalsIgnoreCase("ISINDEX")) {
                Element html = parser.getDocument().getDocumentElement();
                Node child = html.getLastChild();
                while (child != null) {
                    if (child instanceof Element && child.getNodeName().equalsIgnoreCase("HEAD")) {
                        child.insertBefore(errorNode, null);
                        parser.error(code, errorNode + " must be under " + child);
                        return true;
                    }
                    child = child.getPreviousSibling();
                }
            } else {
                if (nodeName.equalsIgnoreCase("BODY")) {
                    Element top = parser.getDocument().getDocumentElement();
                    Node child = top.getFirstChild();
                    while (child != null) {
                        if (child instanceof Element && (child.getNodeName().equalsIgnoreCase("BODY") || child.getNodeName().equalsIgnoreCase("FRAMESET"))) {
                            return false;
                        }
                        child = child.getNextSibling();
                    }
                    top.insertBefore(errorNode, null);
                    parser.setContext((Element)errorNode);
                    parser.error(code, errorNode + " must be under " + top);
                    return true;
                }
                if (nodeName.equalsIgnoreCase("HEAD")) {
                    NodeList bodies;
                    Document doc = parser.getDocument();
                    if (context.getElementsByTagName("HEAD").getLength() == 0 && ((bodies = doc.getElementsByTagName("BODY")).getLength() > 0 || (bodies = doc.getElementsByTagName("FRAMESET")).getLength() > 0)) {
                        Element body = (Element)bodies.item(0);
                        body.getParentNode().insertBefore(errorNode, body);
                        parser.setContext((Element)errorNode);
                        parser.error(code, errorNode + " must be before " + body);
                        return true;
                    }
                    if (doc.getElementsByTagName("BODY").getLength() > 0 || doc.getElementsByTagName("FRAMESET").getLength() > 0) {
                        parser.error(code, "HTMLErrorHandler makes parser ignore " + errorNode);
                        return true;
                    }
                } else if (contextName.equalsIgnoreCase("HTML")) {
                    Node child = context.getLastChild();
                    while (child != null) {
                        if (child instanceof Element && child.getNodeName().equalsIgnoreCase("BODY")) {
                            parser.error(code, "BODY context is already closed.  Reopen it.");
                            parser.reopenContext(1);
                            parser.getContext().insertBefore(errorNode, null);
                            parser.setContext((Element)errorNode);
                            return true;
                        }
                        if (child instanceof Comment || child instanceof ProcessingInstruction || child instanceof Text && this.whitespaceText((Text)child)) {
                            child = child.getPreviousSibling();
                            continue;
                        }
                        break;
                    }
                } else if (nodeName.equalsIgnoreCase(contextName) && ed.endTagOmittable() && contextParent instanceof Element) {
                    contextParent.insertBefore(errorNode, null);
                    parser.setContext((Element)errorNode);
                    return true;
                }
            }
        } else if (code == 6) {
            try {
                Vector missedEndtags = (Vector)parser.getExtraErrInfo();
                Enumeration e = missedEndtags.elements();
                while (e.hasMoreElements()) {
                    EndTag missedEtag = (EndTag)e.nextElement();
                    String missedEtagName = missedEtag.getNodeName();
                    if (missedEtagName.equalsIgnoreCase("TABLE")) {
                        return true;
                    }
                    if (!this.keepForm || !missedEtagName.equalsIgnoreCase("FORM") || !nodeName.equalsIgnoreCase("TD") && !nodeName.equalsIgnoreCase("TR")) continue;
                    return true;
                }
            }
            catch (ClassCastException classCastException) {}
        }
        return false;
    }

    void setKeepForm(boolean keep) {
        this.keepForm = keep;
    }

    private boolean whitespaceText(Text text) {
        if (text instanceof SGMLText) {
            return ((SGMLText)text).getIsWhitespaceInElementContent();
        }
        char[] str = text.getData().toCharArray();
        int i = 0;
        while (i < str.length) {
            if (!Character.isWhitespace(str[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

