/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.win32;

import org.eclipse.actf.util.win32.MemoryUtil;
import org.eclipse.swt.internal.ole.win32.COM;

public class NativeStringAccess {
    private int pBSTRAddress = 0;
    private int[] hMem = new int[1];

    public NativeStringAccess() {
        this.pBSTRAddress = MemoryUtil.GlobalAlloc(4);
    }

    public void dispose() {
        if (this.hMem[0] != 0) {
            COM.SysFreeString((int)this.hMem[0]);
        }
        MemoryUtil.GlobalFree(this.pBSTRAddress);
    }

    public int getAddress() {
        return this.pBSTRAddress;
    }

    public String getString() {
        int size;
        MemoryUtil.MoveMemory(this.hMem, this.pBSTRAddress, 4);
        if (this.hMem[0] != 0 && (size = COM.SysStringByteLen((int)this.hMem[0])) > 0) {
            char[] buffer = new char[(size + 1) / 2];
            MemoryUtil.MoveMemory(buffer, this.hMem[0], size);
            return new String(buffer);
        }
        return null;
    }

    public void setString(String text) {
        MemoryUtil.MoveMemory(this.hMem, this.pBSTRAddress, 4);
        if (this.hMem[0] != 0) {
            COM.SysFreeString((int)this.hMem[0]);
        }
        char[] data = (String.valueOf(text) + "\u0000").toCharArray();
        int ptr = COM.SysAllocString((char[])data);
        COM.MoveMemory((int)this.pBSTRAddress, (int[])new int[]{ptr}, (int)4);
        MemoryUtil.MoveMemory(this.hMem, this.pBSTRAddress, 4);
    }
}

