/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.actf.util.httpproxy.core.IBufferRange;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IMessageBody;
import org.eclipse.actf.util.internal.httpproxy.core.BufferRange;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPMessageBuffer;
import org.eclipse.actf.util.internal.httpproxy.core.MessageBody;

public class HTTPRequestMessage
extends HTTPMessage
implements IHTTPRequestMessage {
    private IBufferRange fMethod = new BufferRange();
    private IBufferRange fRequestURI = new BufferRange();
    private String modifiedRequestURI;
    private IBufferRange fHTTPVersion = new BufferRange();
    private boolean contentLengthInvalidMessage;

    public HTTPRequestMessage(long serial) {
        super(serial);
    }

    public IBufferRange getMethod() {
        return this.fMethod;
    }

    public byte[] getMethodAsBytes() {
        return this.getBuffer().getAsBytes(this.fMethod);
    }

    public String getMethodAsString() {
        return this.getBuffer().getAsString(this.fMethod);
    }

    public IBufferRange getRequestURI() {
        if (this.modifiedRequestURI != null) {
            return null;
        }
        return this.fRequestURI;
    }

    public void setRequestURIString(String newRequestURI) {
        this.modifiedRequestURI = newRequestURI;
    }

    public String getOriginalRequestURIString() {
        return this.getBuffer().getAsString(this.fRequestURI);
    }

    public String getRequestURIString() {
        if (this.modifiedRequestURI != null) {
            return this.modifiedRequestURI;
        }
        return this.getOriginalRequestURIString();
    }

    public IBufferRange getHTTPVersion() {
        return this.fHTTPVersion;
    }

    public byte[] getHTTPVersionAsBytes() {
        return this.getBuffer().getAsBytes(this.fHTTPVersion);
    }

    public String getHTTPVersionAsString() {
        return this.getBuffer().getAsString(this.fHTTPVersion);
    }

    public boolean isMethodEqualsTo(byte[] method) {
        return this.getBuffer().equals(this.fMethod, method);
    }

    protected void writeFirstLine(OutputStream out) throws IOException {
        HTTPMessageBuffer buf = this.getBuffer();
        buf.writeTo(out, this.fMethod);
        out.write(32);
        if (this.modifiedRequestURI == null) {
            buf.writeTo(out, this.fRequestURI);
        } else {
            out.write(this.modifiedRequestURI.getBytes());
        }
        out.write(32);
        buf.writeTo(out, this.fHTTPVersion);
        out.write(13);
        out.write(10);
    }

    protected boolean isBodyEmpty() {
        return false;
    }

    public boolean isResponseBodyEmpty() {
        return "CONNECT".equals(this.getMethodAsString()) || "HEAD".equals(this.getMethodAsString());
    }

    final void recalculateContentLength() {
        IMessageBody body = this.getMessageBody();
        if (body.getContentLength() == -1) {
            this.contentLengthInvalidMessage = true;
            InputStream is = body.getMessageBodyInputStream();
            this.setOriginalMessageBody(new MessageBody(is, 0));
        }
    }

    public boolean isConnectionShutdownRequired() {
        if (!this.isConnectionToBeClosed()) {
            return false;
        }
        IMessageBody body = this.getMessageBody();
        if (body.isChunkedEncoding()) {
            return false;
        }
        return this.contentLengthInvalidMessage || body.getContentLength() < 0;
    }

    protected void writeBodyWithoutContentLength(long timeout, IMessageBody msgBody, OutputStream out) {
    }
}

