/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.internal.httpproxy.core.ChunkDecoder;

public class ChunkEncoder
extends FilterOutputStream {
    static final Logger LOGGER = Logger.getLogger(ChunkEncoder.class);
    public static final int DEFAULT_CHUNK_SIZE = 1024;
    private int fMaxChunkSize;
    private byte[] fChunkBuffer;
    private int fChunkSize;

    public ChunkEncoder(OutputStream out) {
        this(out, 1024);
    }

    public ChunkEncoder(OutputStream out, int maxChunkSize) {
        super(out);
        this.fMaxChunkSize = maxChunkSize;
        this.fChunkSize = 0;
        this.fChunkBuffer = new byte[maxChunkSize];
    }

    public void setMaxChunkSize(int maxChunkSize) throws IOException {
        if (this.fMaxChunkSize == maxChunkSize) {
            return;
        }
        if (this.fChunkSize > 0) {
            this.flushChunk();
        }
        this.fMaxChunkSize = maxChunkSize;
        this.fChunkBuffer = new byte[maxChunkSize];
    }

    public void write(int b) throws IOException {
        this.fChunkBuffer[this.fChunkSize++] = (byte)b;
        if (this.fChunkSize == this.fMaxChunkSize) {
            this.flushChunk();
        }
    }

    public void flush() throws IOException {
        this.flushChunk();
        this.out.flush();
    }

    public void close() throws IOException {
        this.flushChunk();
        this.out.write(48);
        this.out.write(13);
        this.out.write(10);
        this.out.write(13);
        this.out.write(10);
        this.out.close();
    }

    private void flushChunk() throws IOException {
        if (this.fChunkSize > 0) {
            byte[] size = Integer.toHexString(this.fChunkSize).getBytes();
            this.out.write(size);
            this.out.write(13);
            this.out.write(10);
            this.out.write(this.fChunkBuffer, 0, this.fChunkSize);
            this.out.write(13);
            this.out.write(10);
            this.fChunkSize = 0;
        }
    }

    public static void main(String[] args) throws Exception {
        int b;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        ChunkEncoder encoder = new ChunkEncoder(buf, 10);
        int i = 0;
        while (i < 39) {
            int b2 = i & 0xFF;
            encoder.write(b2);
            ++i;
        }
        encoder.close();
        byte[] a = buf.toByteArray();
        int i2 = 0;
        while (i2 < a.length) {
            byte b3 = a[i2];
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            sb.append(Integer.toString(i2));
            sb.append("] ");
            sb.append(Integer.toString(b3));
            if (Character.isLetterOrDigit((char)b3)) {
                sb.append(" '").append((char)b3).append('\'');
            }
            String line = sb.toString();
            System.out.println(line);
            ++i2;
        }
        System.out.println();
        ChunkDecoder decoder = new ChunkDecoder(new ByteArrayInputStream(a));
        int i3 = 0;
        while ((b = decoder.read()) >= 0) {
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            sb.append(Integer.toString(i3));
            sb.append("] ");
            sb.append(Integer.toString(b));
            String line = sb.toString();
            System.out.println(line);
            ++i3;
        }
    }
}

