/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.httpproxy.util;

import java.io.IOException;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponsePushbackMessage;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyConnection;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseInMemoryMessage;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponsePushbackMessage;

public class HTTPUtil {
    public static void sendFailedToClient(IHTTPProxyConnection fClient, IHTTPRequestMessage request) throws InterruptedException, IOException {
        fClient.sendResponse(new HTTPResponseInMemoryMessage(request.getSerial(), IHTTPHeader.HTTP_VERSION_1_0_A, "404".getBytes(), "Not found".getBytes(), IHTTPResponseMessage.EMPTY_BODY));
    }

    public static IHTTPResponseMessage createHTTPResponseInMemoryMessage(IHTTPResponseMessage base, byte[] body) {
        return new HTTPResponseInMemoryMessage(base, body);
    }

    public static IHTTPResponseMessage createHTTPResponseInMemoryMessage(long serial, byte[] version, byte[] statusCode, byte[] reasonPhrase, byte[] body) {
        return new HTTPResponseInMemoryMessage(serial, version, statusCode, reasonPhrase, body);
    }

    public static IHTTPResponsePushbackMessage createHTTPResponsePushbackMessage(IHTTPResponseMessage base, int pushbackBufferSize) {
        return new HTTPResponsePushbackMessage(base, pushbackBufferSize);
    }
}

