/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.ui.scripteditor.views;

import java.net.URI;
import org.eclipse.actf.ai.internal.ui.scripteditor.PreviewPanel;
import org.eclipse.actf.ai.internal.ui.scripteditor.ScriptAudioComposite;
import org.eclipse.actf.ai.internal.ui.scripteditor.TimeLineCanvas;
import org.eclipse.actf.ai.internal.ui.scripteditor.VolumeLevelCanvas;
import org.eclipse.actf.ai.internal.ui.scripteditor.XMLFileMessageBox;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.EventManager;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.MouseDragEvent;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.MouseDragEventListener;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.PlayerControlEvent;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.SyncTimeEvent;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.SyncTimeEventListener;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.TimerEvent;
import org.eclipse.actf.ai.internal.ui.scripteditor.event.TimerEventListener;
import org.eclipse.actf.ai.scripteditor.data.ScriptData;
import org.eclipse.actf.ai.scripteditor.data.XMLFileSaveUtil;
import org.eclipse.actf.ai.scripteditor.util.ScriptFileDropListener;
import org.eclipse.actf.ai.scripteditor.util.SoundMixer;
import org.eclipse.actf.ai.scripteditor.util.VoicePlayerFactory;
import org.eclipse.actf.ai.scripteditor.util.WebBrowserFactory;
import org.eclipse.actf.ai.ui.scripteditor.views.EditPanelView;
import org.eclipse.actf.ai.ui.scripteditor.views.IUNIT;
import org.eclipse.actf.ai.ui.scripteditor.views.ScriptListView;
import org.eclipse.actf.examples.scripteditor.ScriptEditorShutdownListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class TimeLineView
extends ViewPart
implements IUNIT,
SyncTimeEventListener,
MouseDragEventListener,
TimerEventListener {
    public static final String VIEW_ID = "org.eclipse.actf.examples.scripteditor.VolumeLevelView";
    protected Composite parentComposite;
    protected Composite ownComposite;
    private ScrolledComposite parentSC;
    private ScrolledComposite ownSC;
    private Composite childComposite;
    private static TimeLineView ownInst = null;
    private Display ownDisplay = null;
    private Slider sliderTimeLine;
    protected ScriptData instScriptData = null;
    private VoicePlayerFactory voicePlayer = null;
    private boolean previousPlayerStatus = false;
    private boolean previewVoiceGender;
    private int previewVoiceSpeed;
    private int previewVoicePitch;
    private String previewVoiceDesc = new String();
    private TimeLineCanvas canvasTimeLine = null;
    private VolumeLevelCanvas canvasVolumeLevel = null;
    private ScriptAudioComposite compositeScriptAudio = null;
    private int startTimeLine = 0;
    private int endTimeLine = 600000;
    private int currentTimeLine = 0;
    private int currentStatusTimeLine = 0;
    private int movieEndTimeLine = 0;
    private int currentMovieTimeLine = 0;
    private int currentMovieStatus = -1;
    private int previousMovieStatus = -1;
    private int currentTimeLineLocation = 0;
    private int previousTimeLine = -1;
    private int pauseTimeLine = 0;
    private int indexCurrentScriptData = 0;
    private boolean currentVoiceEngineAction = false;
    private int countDurationVoice = -1;
    private boolean currentEnableDescription = true;
    private String saveFileName = null;
    private Label labelVolumeLevel;
    private Label labelAudio1;
    private int current_lines_timeline = 3;
    private FormData ParentSCTimeLineLData;
    private FormData compositeScriptAudioLData;
    private FormData labelAudio1LData;
    private static EventManager eventManager = null;
    private static final int WAIT_COUNT_FOR_VIDEO_PLAY = 3;
    private int videoPlayCount = 3;
    private boolean currentDragStatus = false;
    private int timerUtilCounter = 50;
    private int indexScriptData = 0;
    private int ownCurrentTimeLine = 0;
    private int ownPreviousTimeLine = 0;

    public TimeLineView() {
        PlatformUI.getWorkbench().addWorkbenchListener((IWorkbenchListener)new ScriptEditorShutdownListener());
        ownInst = this;
        eventManager = EventManager.getInstance();
    }

    public static TimeLineView getInstance() {
        return ownInst;
    }

    public void createPartControl(Composite parent) {
        this.parentComposite = parent;
        this.parentSC = new ScrolledComposite(parent, 512);
        this.instScriptData = ScriptData.getInstance();
        this.voicePlayer = new VoicePlayerFactory();
        this.ownDisplay = PlatformUI.getWorkbench().getDisplay();
        this.initGUI(this.ownDisplay);
        this.initDDListener(this.ownComposite);
        eventManager.addSyncTimeEventListener(this);
        eventManager.addMouseDragEventListener(this);
        eventManager.addTimerEventListener(this);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                eventManager.removeSyncTimeEventListener(ownInst);
                eventManager.removeMouseDragEventListener(ownInst);
                eventManager.removeTimerEventListener(ownInst);
            }
        });
        this.videoPlayCount = 3;
    }

    public void setFocus() {
        this.ownSC.setFocus();
        this.childComposite.setFocus();
        this.ownComposite.setFocus();
        this.canvasTimeLine.setFocus();
        this.compositeScriptAudio.setFocus();
        this.canvasVolumeLevel.setFocus();
    }

    public void dispose() {
        this.setStatusTimeLine(-1);
        this.reqStopScriptAudio();
        this.reqStopCaptureAudio();
        eventManager = null;
        super.dispose();
    }

    private void initGUI(Display parentDisp) {
        try {
            int adj_height = 54;
            FormLayout ParentSCTimeLineLayout = new FormLayout();
            this.parentSC.setLayout((Layout)ParentSCTimeLineLayout);
            this.ParentSCTimeLineLData = new FormData();
            this.ParentSCTimeLineLData.width = 547;
            this.ParentSCTimeLineLData.height = 118 + adj_height;
            this.ParentSCTimeLineLData.top = new FormAttachment(5, 1000, 0);
            this.ParentSCTimeLineLData.left = new FormAttachment(592, 1000, 0);
            this.ParentSCTimeLineLData.right = new FormAttachment(0, 1000, 441);
            this.parentSC.setLayoutData((Object)this.ParentSCTimeLineLData);
            this.ownComposite = new Composite((Composite)this.parentSC, 0);
            FormLayout viewTimeLinelLayout = new FormLayout();
            this.ownComposite.setLayout((Layout)viewTimeLinelLayout);
            FormData viewTimeLineLData = new FormData();
            viewTimeLineLData.top = new FormAttachment(0, 1000, 0);
            viewTimeLineLData.left = new FormAttachment(0, 1000, 0);
            viewTimeLineLData.right = new FormAttachment(1000, 1000, 0);
            viewTimeLineLData.bottom = new FormAttachment(1000, 1000, 0);
            this.ownComposite.setLayoutData((Object)viewTimeLineLData);
            PreviewPanel.getInstance().initPreviewPanel(parentDisp, this.ownComposite);
            this.parentSC.setContent((Control)this.ownComposite);
            this.parentSC.setSize(this.ownComposite.computeSize(-1, -1));
            this.parentSC.setMinHeight(118 + adj_height);
            this.parentSC.setExpandHorizontal(true);
            this.parentSC.setExpandVertical(true);
            FormData sliderTimeLineLayoutData = new FormData();
            sliderTimeLineLayoutData.height = 16;
            sliderTimeLineLayoutData.left = new FormAttachment(0, 1000, 80);
            sliderTimeLineLayoutData.right = new FormAttachment(1000, 1000, -2);
            sliderTimeLineLayoutData.bottom = new FormAttachment(1000, 1000, -2);
            this.sliderTimeLine = new Slider(this.ownComposite, 256);
            this.sliderTimeLine.setLayoutData((Object)sliderTimeLineLayoutData);
            this.sliderTimeLine.setIncrement(1);
            this.sliderTimeLine.setMinimum(1);
            this.sliderTimeLine.addSelectionListener((SelectionListener)new SliderTimeLineSelectionAdapter());
            this.ownSC = new ScrolledComposite(this.ownComposite, 2048);
            FormLayout SCTimeLineLayout = new FormLayout();
            this.ownSC.setLayout((Layout)SCTimeLineLayout);
            FormData SCTimeLineLData = new FormData();
            SCTimeLineLData.width = 479;
            SCTimeLineLData.top = new FormAttachment((Control)PreviewPanel.getInstance().getPlayButton(), 2);
            SCTimeLineLData.left = new FormAttachment(0, 1000, 80);
            SCTimeLineLData.right = new FormAttachment(1000, 1000, -2);
            SCTimeLineLData.bottom = new FormAttachment((Control)this.sliderTimeLine, 0);
            this.ownSC.setLayoutData((Object)SCTimeLineLData);
            this.reqSetMaximumSliderTimeLine(this.getMaxTimeLine());
            this.childComposite = new Composite((Composite)this.ownSC, 0);
            FormLayout childTimeLineLayout = new FormLayout();
            this.childComposite.setLayout((Layout)childTimeLineLayout);
            FormData childTimeLineLData = new FormData();
            childTimeLineLData.top = new FormAttachment(0, 1000, 0);
            childTimeLineLData.left = new FormAttachment(0, 1000, 0);
            childTimeLineLData.right = new FormAttachment(1000, 1000, 0);
            childTimeLineLData.bottom = new FormAttachment(1000, 1000, 0);
            this.childComposite.setLayoutData((Object)childTimeLineLData);
            this.canvasTimeLine = TimeLineCanvas.getInstance(this.childComposite);
            FormLayout canvasTimeLineLayout = new FormLayout();
            this.canvasTimeLine.setLayout((Layout)canvasTimeLineLayout);
            FormData canvasTimeLineLData = new FormData();
            canvasTimeLineLData.height = 20;
            canvasTimeLineLData.top = new FormAttachment(0, 1000, 0);
            canvasTimeLineLData.left = new FormAttachment(0, 1000, 0);
            canvasTimeLineLData.right = new FormAttachment(1000, 1000, 0);
            this.canvasTimeLine.setLayoutData(canvasTimeLineLData);
            this.canvasTimeLine.setBackground(parentDisp.getSystemColor(1));
            this.canvasTimeLine.pack();
            this.reqRedrawTimeLineCanvas(1);
            this.compositeScriptAudio = ScriptAudioComposite.getInstance(this.childComposite);
            FormLayout compositeScriptAudioLayout = new FormLayout();
            this.compositeScriptAudio.setLayout((Layout)compositeScriptAudioLayout);
            this.compositeScriptAudioLData = new FormData();
            this.compositeScriptAudioLData.height = 8 + adj_height;
            this.compositeScriptAudioLData.left = new FormAttachment(0, 1000, 0);
            this.compositeScriptAudioLData.right = new FormAttachment(1000, 1000, 0);
            this.compositeScriptAudioLData.bottom = new FormAttachment(1000, 1000, 0);
            this.compositeScriptAudio.setLayoutData(this.compositeScriptAudioLData);
            this.compositeScriptAudio.setBackground(new Color((Device)parentDisp, 255, 239, 215));
            this.compositeScriptAudio.pack();
            this.labelVolumeLevel = new Label(this.ownComposite, 0);
            this.labelVolumeLevel.setVisible(false);
            this.labelVolumeLevel.setText("Volume Level");
            this.canvasVolumeLevel = VolumeLevelCanvas.getInstance(this.childComposite);
            FormLayout canvasVolumeLevelLayout = new FormLayout();
            this.canvasVolumeLevel.setLayout((Layout)canvasVolumeLevelLayout);
            FormData canvasVolumeLevelLData = new FormData();
            canvasVolumeLevelLData.top = new FormAttachment((Control)this.canvasTimeLine, 0);
            canvasVolumeLevelLData.left = new FormAttachment(0, 1000, 0);
            canvasVolumeLevelLData.right = new FormAttachment(1000, 1000, 0);
            canvasVolumeLevelLData.bottom = new FormAttachment((Control)this.compositeScriptAudio, 0);
            this.canvasVolumeLevel.setLayoutData(canvasVolumeLevelLData);
            this.canvasVolumeLevel.setBackground(parentDisp.getSystemColor(1));
            this.canvasVolumeLevel.pack();
            this.reqRedrawVolumeLevelCanvas(1);
            this.labelVolumeLevel.setVisible(true);
            int bottom = 62;
            this.labelAudio1LData = new FormData();
            this.labelAudio1LData.width = 70;
            this.labelAudio1LData.left = new FormAttachment(0, 1000, 4);
            this.labelAudio1LData.bottom = new FormAttachment(1000, 1000, -bottom);
            this.labelAudio1 = new Label(this.ownComposite, 0);
            this.labelAudio1.setLayoutData((Object)this.labelAudio1LData);
            this.labelAudio1.setText("Audio 1");
            this.labelAudio1.setAlignment(131072);
            this.ownSC.setContent((Control)this.childComposite);
            this.ownSC.setSize(this.childComposite.computeSize(-1, -1));
            this.ownSC.setMinWidth(this.endTimeLine / 20);
            this.ownSC.setExpandHorizontal(true);
            this.ownSC.setExpandVertical(true);
            this.ownSC.addPaintListener((PaintListener)new ResizeScrolledCompositeListener());
            this.childComposite.layout();
            this.childComposite.pack();
            this.ownComposite.layout();
            this.ownComposite.pack();
        }
        catch (Exception e) {
            System.out.println("TimeLineView() : Exception = " + e);
        }
    }

    private void adjustLayoutTimeLine(int lines) {
        int nowLine = this.current_lines_timeline;
        this.current_lines_timeline = lines;
        if (this.current_lines_timeline < 3) {
            this.current_lines_timeline = 3;
        }
        int adj_height = this.current_lines_timeline * 18;
        this.ownComposite.layout(true, true);
        Point nowPon = this.parentSC.getSize();
        this.ParentSCTimeLineLData.height = nowPon.y - nowLine * 18 + adj_height;
        this.parentSC.setLayoutData((Object)this.ParentSCTimeLineLData);
        this.parentSC.layout(true, true);
        this.parentSC.pack();
        this.parentSC.setSize(nowPon.x, this.ParentSCTimeLineLData.height);
        this.parentSC.setMinHeight(this.ParentSCTimeLineLData.height + 1);
        nowPon = this.compositeScriptAudio.getSize();
        this.compositeScriptAudioLData.height = 8 + adj_height;
        this.compositeScriptAudio.setLayoutData(this.compositeScriptAudioLData);
        this.compositeScriptAudio.layout(true, true);
        this.compositeScriptAudio.setSize(nowPon.x, adj_height);
        this.labelAudio1LData.bottom = new FormAttachment(1000, 1000, -adj_height);
        this.labelAudio1.setLayoutData((Object)this.labelAudio1LData);
        this.childComposite.layout(true, true);
        this.ownSC.layout(true, true);
    }

    private void initDDListener(Composite parent) {
        DropTarget targetDnD = new DropTarget((Control)parent, 17);
        targetDnD.setTransfer(new Transfer[]{FileTransfer.getInstance()});
        targetDnD.addDropListener((DropTargetListener)new ScriptFileDropListener());
    }

    public int getStartTimeLine() {
        return this.startTimeLine;
    }

    public int getEndTimeLine() {
        return this.endTimeLine;
    }

    public int getMovieEndTimeLine() {
        return this.movieEndTimeLine;
    }

    public int getCurrentTimeLine() {
        return this.currentTimeLine;
    }

    public int getMaxScrollBar() {
        return this.sliderTimeLine.getMaximum();
    }

    public int getCurrentValueScrollBar() {
        return this.sliderTimeLine.getSelection();
    }

    public Point getCurrentSizeScrollBar() {
        return this.sliderTimeLine.getSize();
    }

    public int getCurrentLocation() {
        return this.currentTimeLineLocation;
    }

    public Point getSizeParentSC() {
        Point result = new Point(0, 0);
        if (this.ownSC != null) {
            result = this.ownSC.getSize();
        }
        return result;
    }

    public boolean getEnableDescription() {
        return this.currentEnableDescription;
    }

    public String reqGetXMLFilePath() {
        return this.saveFileName;
    }

    public void reqStoreXMLFilePath(String nowFileName) {
        this.saveFileName = nowFileName;
    }

    public void reqStoreVolLvlFilePath(String nowFileName) {
        this.canvasVolumeLevel.setSavePathVolLvl(nowFileName);
    }

    public void reqAdjustLayoutTimeLine(int lines) {
        this.adjustLayoutTimeLine(lines);
    }

    public int reqGetCurrentLineAudioLabel() {
        return this.current_lines_timeline - 1;
    }

    public boolean reqConfirmSaveData() {
        boolean result = true;
        int stat = this.instScriptData.getStatusSaveScripts();
        if (stat > 0) {
            String filePath;
            XMLFileMessageBox confMB;
            int ret;
            if (stat == 2) {
                stat = 1;
            }
            if ((ret = (confMB = new XMLFileMessageBox(stat, filePath = this.reqGetXMLFilePath())).open()) == 64) {
                XMLFileSaveUtil saveFH = new XMLFileSaveUtil();
                String newFile = filePath;
                if (newFile == null) {
                    newFile = saveFH.open();
                }
                saveFH.save(newFile, false);
            } else if (ret == 256) {
                result = false;
            }
        }
        return result;
    }

    public void setCurrentLocation(int nowLocation) {
        Point nowSize = this.ownSC.getSize();
        int nowEndTime = (nowLocation + nowSize.x) * 20;
        this.currentTimeLineLocation = nowEndTime / 300000 - 1;
        if (this.currentTimeLineLocation < 0) {
            this.currentTimeLineLocation = 0;
        }
        if (this.currentTimeLineLocation >= 20) {
            this.currentTimeLineLocation = 19;
        } else if (this.currentTimeLineLocation < 0) {
            this.currentTimeLineLocation = 0;
        }
    }

    public void setResizeTimeLine(int maxTime) {
        int newWidth = maxTime / 20;
        this.ownSC.setMinWidth(newWidth);
    }

    public void setLocationTimeLineSlider(int movieEndTime, int currentTime) {
        this.sliderTimeLine.setSelection(currentTime);
        this.reqSetMaximumSliderTimeLine(movieEndTime);
    }

    public void setPositionLabelVolumeLevel(int centreY) {
        if (this.labelVolumeLevel != null) {
            int nextY = centreY + 20 + 2 + 23;
            FormData labelVolumeLevelLData = new FormData();
            labelVolumeLevelLData.width = 70;
            labelVolumeLevelLData.top = new FormAttachment(0, 1000, nextY);
            labelVolumeLevelLData.left = new FormAttachment(0, 1000, 4);
            this.labelVolumeLevel.setLayoutData((Object)labelVolumeLevelLData);
            this.labelVolumeLevel.setAlignment(131072);
            Point nowPos = this.labelVolumeLevel.getLocation();
            nowPos.y = nextY;
            this.labelVolumeLevel.setLocation(nowPos);
        }
    }

    public void setCurrentValueScrollBar(int value) {
        this.sliderTimeLine.setSelection(value);
    }

    public void setEnableDescription(boolean stat) {
        this.currentEnableDescription = stat;
    }

    public URI reqGetVolLvlPath() {
        return this.canvasVolumeLevel.getSavePathVolLvl();
    }

    public void reqSaveVolumeLevelTempFile() {
        this.canvasVolumeLevel.saveVolumeLevelTempFile();
    }

    public void reqScrollHorizontalTimeLine(int nowLocation) {
        int newLocation = nowLocation;
        Point nowPon = this.ownSC.getSize();
        int posEndTime = this.getMaxTimeLine() / 20;
        if (newLocation > posEndTime - nowPon.x) {
            newLocation = posEndTime - nowPon.x;
        }
        Point newPon = this.childComposite.getLocation();
        newPon.x = -(newLocation -= this.currentTimeLineLocation * 300000 / 20);
        this.childComposite.setLocation(newPon);
    }

    public void reqSetMaximumSliderTimeLine(int endTime) {
        int maxWidth = endTime / 20;
        Point nowPon = this.ownSC.getSize();
        int sliderMaxWidth = maxWidth - nowPon.x;
        this.sliderTimeLine.setMaximum(sliderMaxWidth);
    }

    public int isEndTimeLine(int nowLocation) {
        int result = 0;
        Point nowSize = this.ownSC.getSize();
        int nowEndTime = (nowLocation + nowSize.x) * 20;
        int nowStartTime = nowLocation * 20;
        int previousEndTime = (this.currentTimeLineLocation + 2) * 300000;
        int previousStartTime = this.currentTimeLineLocation * 300000;
        if (nowEndTime >= previousEndTime) {
            result = 1;
        } else if (nowStartTime < previousStartTime && previousStartTime > 0) {
            result = -1;
        }
        return result;
    }

    public void reqInitLocationTimeLine() {
        this.startTimeLine = 0;
        this.currentTimeLine = 0;
        this.endTimeLine = this.movieEndTimeLine = PreviewPanel.getInstance().getVideoTotalTime();
        int lastIndex = this.instScriptData.getLengthScriptList() - 1;
        if (lastIndex >= 0) {
            int endTime = this.instScriptData.getScriptEndTime(lastIndex);
            if (endTime > this.endTimeLine) {
                this.endTimeLine = endTime;
            }
        } else if (this.endTimeLine == 0) {
            this.endTimeLine = 600000;
        }
        int unitCount = this.endTimeLine / 300000;
        if (this.endTimeLine % 300000 > 0) {
            ++unitCount;
        }
        this.endTimeLine = unitCount * 300000;
        this.setCurrentLocation(0);
        this.seekIndexTimeLine(this.currentTimeLine);
        this.synchronizeAllTimeLine(this.currentTimeLine);
    }

    public void reqSeekLocationTimeLine() {
        this.startTimeLine = 0;
        this.endTimeLine = this.movieEndTimeLine = PreviewPanel.getInstance().getVideoTotalTime();
        int lastIndex = this.instScriptData.getLengthScriptList() - 1;
        if (lastIndex >= 0) {
            int endTime = this.instScriptData.getScriptEndTime(lastIndex);
            if (endTime > this.endTimeLine) {
                this.endTimeLine = endTime;
            }
        } else if (this.endTimeLine == 0) {
            this.endTimeLine = 600000;
        }
        int unitCount = this.endTimeLine / 300000;
        if (this.endTimeLine % 300000 > 0) {
            ++unitCount;
        }
        this.endTimeLine = unitCount * 300000;
        if (this.currentTimeLine < this.movieEndTimeLine) {
            this.currentTimeLine = PreviewPanel.getInstance().getVideoCurrentPosition();
        }
        this.seekIndexTimeLine(this.currentTimeLine);
        this.synchronizeAllTimeLine(this.currentTimeLine);
    }

    public void reqSetupTimeLine() {
        if (this.currentStatusTimeLine > 0) {
            this.startTimeLine = 0;
            this.movieEndTimeLine = PreviewPanel.getInstance().getVideoTotalTime();
            int lastIndex = this.instScriptData.getLengthScriptList() - 1;
            if (lastIndex >= 0) {
                int endTime = this.instScriptData.getScriptEndTime(lastIndex);
                if (endTime > this.endTimeLine) {
                    this.endTimeLine = endTime;
                }
            } else if (this.endTimeLine == 0) {
                this.endTimeLine = 600000;
            }
            int unitCount = this.endTimeLine / 300000;
            if (this.endTimeLine % 300000 > 0) {
                ++unitCount;
            }
            this.endTimeLine = unitCount * 300000;
            if (this.currentTimeLine < this.movieEndTimeLine) {
                this.currentTimeLine = PreviewPanel.getInstance().getVideoCurrentPosition();
            }
            this.seekIndexTimeLine(this.currentTimeLine);
            if (this.currentStatusTimeLine == 1) {
                this.synchronizeAllTimeLine(this.currentTimeLine);
            }
        }
    }

    public void reqSetTrackCurrentTimeLine(int newTime) {
        this.currentTimeLine = newTime;
        this.seekIndexTimeLine(this.currentTimeLine);
    }

    public void reqRewindTimeLine() {
        this.setCurrentLocation(0);
        this.repaintAllTimeLine();
        int intdev = this.getMaxTimeLine() / 300000;
        if (this.getMaxTimeLine() % 300000 > 0) {
            ++intdev;
        }
        this.setLocationTimeLineSlider(intdev * 300000, 0);
    }

    public boolean reqExpandTimeLine() {
        boolean result = false;
        int index = -1;
        index = this.instScriptData.getLengthScriptList() - 1;
        if (index >= 0) {
            int endTime = this.instScriptData.getScriptEndTime(index);
            Point nowPon = this.childComposite.getSize();
            int maxTimeComp = nowPon.x * 20;
            if (maxTimeComp < 0) {
                maxTimeComp = 0;
            }
            if (endTime > 600000 && endTime > maxTimeComp) {
                this.setMaxTimeLine(endTime);
                this.reqSetMaximumSliderTimeLine(this.getMaxTimeLine());
                PreviewPanel.getInstance().synchronizeTimeLine(this.getCurrentTimeLine());
                result = true;
            }
        }
        return result;
    }

    public void reqExpandTimeLine(int newEndTime) {
        int endTime = this.getMaxTimeLine();
        if (newEndTime > endTime) {
            this.setMaxTimeLine(newEndTime);
            this.reqSetMaximumSliderTimeLine(this.getMaxTimeLine());
            PreviewPanel.getInstance().synchronizeTimeLine(this.getCurrentTimeLine());
        }
    }

    public void reqUpdateLocationTimeLine(int index) {
        int nextValue;
        int nextStartTime = this.instScriptData.getScriptStartTime(index);
        if (nextStartTime < 0) {
            nextStartTime = 0;
        }
        Point scPos = this.getCurrentSizeScrollBar();
        int sliderStartTime = nextStartTime / 20 - (scPos.x >> 1);
        if (this.isEndTimeLine(sliderStartTime) != 0) {
            this.setCurrentLocation(sliderStartTime);
            int newEndTime = (this.currentTimeLineLocation + 2) * 300000;
            if (newEndTime > this.getMaxTimeLine()) {
                this.setMaxTimeLine(newEndTime);
                this.reqSetMaximumSliderTimeLine(this.getMaxTimeLine());
                PreviewPanel.getInstance().synchronizeTimeLine(this.getCurrentTimeLine());
            }
            this.repaintAllTimeLine();
        }
        if ((nextValue = nextStartTime / 20 - (scPos.x >> 1)) < 0) {
            nextValue = 0;
        }
        this.setCurrentValueScrollBar(nextValue);
        int targetTime = nextStartTime - this.currentTimeLineLocation * 300000;
        if (targetTime < 0) {
            targetTime = 0;
        }
        if ((nextValue = targetTime / 20 - (scPos.x >> 1)) < 0) {
            nextValue = 0;
        }
        Rectangle nowPon = this.childComposite.getBounds();
        int nextCentre = -nextValue;
        if (-nextCentre + scPos.x > nowPon.width) {
            nextValue = nowPon.width - scPos.x;
            nextCentre = -nextValue;
        }
        this.childComposite.setLocation(nextCentre, nowPon.y);
        WebBrowserFactory.getInstance().setCurrentPosition(nextStartTime);
    }

    public void updateLocationTimeLine(int nextTime) {
        int nextValue;
        Point scPos = this.getCurrentSizeScrollBar();
        int sliderStartTime = nextTime / 20 - (scPos.x >> 1);
        if (this.isEndTimeLine(sliderStartTime) != 0) {
            this.setCurrentLocation(sliderStartTime);
            int newEndTime = (this.currentTimeLineLocation + 2) * 300000;
            if (newEndTime > this.getMaxTimeLine()) {
                this.setMaxTimeLine(newEndTime);
                this.reqSetMaximumSliderTimeLine(this.getMaxTimeLine());
                PreviewPanel.getInstance().synchronizeTimeLine(this.getCurrentTimeLine());
            }
            this.repaintAllTimeLine();
        }
        if ((nextValue = nextTime / 20 - (scPos.x >> 1)) < 0) {
            nextValue = 0;
        }
        this.setCurrentValueScrollBar(nextValue);
        int targetTime = nextTime - this.currentTimeLineLocation * 300000;
        if (targetTime < 0) {
            targetTime = 0;
        }
        if ((nextValue = targetTime / 20 - (scPos.x >> 1)) < 0) {
            nextValue = 0;
        }
        Rectangle nowPon = this.childComposite.getBounds();
        int nextCentre = -nextValue;
        if (-nextCentre + scPos.x > nowPon.width) {
            nextValue = nowPon.width - scPos.x;
            nextCentre = -nextValue;
        } else if (nextCentre > 0) {
            nextValue = 0;
            nextCentre = 0;
        }
        this.childComposite.setLocation(nextCentre, nowPon.y);
    }

    public void resetLocationTimeLine(int startTime, int labelEndTime) {
        int nextValue = startTime / 20;
        Rectangle nowPon = this.childComposite.getBounds();
        int nextCentre = -nextValue;
        this.reqExpandTimeLine(labelEndTime);
        this.setCurrentValueScrollBar(nextValue += this.currentTimeLineLocation * 15000);
        this.childComposite.setLocation(nextCentre, nowPon.y);
    }

    public void repaintAllTimeLine() {
        int nowCnt = this.getCurrentLocation();
        eventManager.fireSyncTimeEvent(new SyncTimeEvent(1, nowCnt, this));
    }

    public void synchronizeAllTimeLine(int nowTime) {
        eventManager.fireSyncTimeEvent(new SyncTimeEvent(nowTime, this));
    }

    private void synchronizeTimeLine(int nowTime) {
        this.updateLocationTimeLine(nowTime);
    }

    public void reqRedrawTimeLineCanvas(int stat) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                TimeLineView.this.canvasTimeLine.initPositionMarkerTimeLine();
            }
        });
    }

    public void reqRedrawVolumeLevelCanvas(int stat) {
        this.canvasVolumeLevel.setStatusCanvasVolumeLevel(stat);
    }

    public void reqCleanupCaptureData() {
        this.canvasVolumeLevel.cleanupMovieAudioLevel();
    }

    public void reqLoadVolumeLevelData() {
        this.canvasVolumeLevel.loadVolumeLevelTempFile();
    }

    public void reqRefreshScriptData(int currentStartTime, int newStartTime, int newEndTime, int newEndTimeWav, boolean dspMode) {
        EditPanelView.getInstance().getInstanceTabEditPanel().refreshScriptData(currentStartTime, newStartTime, newEndTime, dspMode);
        EditPanelView.getInstance().getInstanceTabSelWAVFile().refreshScriptData(currentStartTime, newStartTime, newEndTimeWav, dspMode);
    }

    public void reqPlayAudio(int indexScriptData) {
        int startTime = this.instScriptData.getScriptStartTime(indexScriptData);
        int wavno = this.instScriptData.getIndexWavList(startTime);
        boolean enaWav = this.instScriptData.getEnableWavList(wavno);
        if (!enaWav || wavno < 0) {
            if (this.instScriptData.getExtendExtended(indexScriptData).booleanValue()) {
                PreviewPanel.getInstance().controlExtendedPlay(true);
                this.setStatusTimeLine(5);
            }
            this.voicePlayer.setPlayVoiceStatus(1);
            this.reqStartVoicePlayer(indexScriptData);
        } else {
            if (this.instScriptData.getExtendExtended(indexScriptData).booleanValue()) {
                PreviewPanel.getInstance().controlExtendedPlay(true);
                this.setStatusTimeLine(5);
            }
            URI wavFName = this.instScriptData.getFileNameWavList(wavno);
            float wavCompetitiveRatio = this.instScriptData.getPlaySpeedWavList(wavno);
            SoundMixer.getInstance().startPlaySound(wavFName, wavCompetitiveRatio);
        }
    }

    public boolean isRunningAudio() {
        boolean result = this.isSamplingScriptAudio() | SoundMixer.getInstance().isRunningPlaySound();
        return result;
    }

    public Boolean isSamplingScriptAudio() {
        return this.voicePlayer.getPlayVoiceStatus();
    }

    public void reqSetupScriptAudio(String lang, String strGender, int speed, int pitch, int volume) {
        this.voicePlayer.setLang(lang);
        this.voicePlayer.setGender(strGender);
        this.voicePlayer.setSpeed(speed);
        this.voicePlayer.setPitch(pitch);
        this.voicePlayer.setVolume(volume);
    }

    public boolean isConsistencyScriptData() {
        boolean result = false;
        if (this.previewVoiceDesc.equals(EditPanelView.getInstance().getInstanceTabEditPanel().getCurrentDescription()) && this.previewVoiceGender == EditPanelView.getInstance().getInstanceTabEditPanel().getCurrentGender() && this.previewVoiceSpeed == EditPanelView.getInstance().getInstanceTabEditPanel().getCurrentSpeed() && this.previewVoicePitch == EditPanelView.getInstance().getInstanceTabEditPanel().getCurrentPitch()) {
            result = true;
        }
        return result;
    }

    public void reqPlayScriptAudio(String currentScriptText) {
        this.voicePlayer.setPlayVoiceStatus(1);
        this.previewVoiceGender = EditPanelView.getInstance().getInstanceTabEditPanel().getCurrentGender();
        this.previewVoiceSpeed = EditPanelView.getInstance().getInstanceTabEditPanel().getCurrentSpeed();
        this.previewVoicePitch = EditPanelView.getInstance().getInstanceTabEditPanel().getCurrentPitch();
        this.previewVoiceDesc = currentScriptText;
        this.voicePlayer.speak(currentScriptText);
    }

    public void reqStopScriptAudio() {
        this.voicePlayer.stop();
    }

    public void reqStopCaptureAudio() {
        SoundMixer.getInstance().stopCaptureSound();
        SoundMixer.getInstance().stopPlaySound();
        SoundMixer.getInstance().dispose();
    }

    public void reqStartVoicePlayer(int index) {
        this.reqSetupScriptAudio(this.instScriptData.getExtendLang(index), this.instScriptData.getExtendGender(index) != false ? "male" : "female", this.instScriptData.getExtendSpeed(index), this.instScriptData.getExtendPitch(index), this.instScriptData.getExtendVolume(index));
        this.voicePlayer.speak(this.instScriptData.getScriptData(index));
    }

    public void reqResumeVoicePlayer() {
        this.voicePlayer.resume();
    }

    public void reqStopVoicePlayer() {
        this.voicePlayer.stop();
    }

    public void reqPauseVoicePlayer() {
        this.voicePlayer.pause();
    }

    public void reqSelectScriptData(int startTime) {
        int index = this.instScriptData.searchScriptData(startTime);
        if (index >= 0) {
            String strDesc = this.instScriptData.getScriptData(index);
            EditPanelView.getInstance().getInstanceTabEditPanel().repaintTextScriptData(index);
            EditPanelView.getInstance().getInstanceTabSelWAVFile().startDescriptionStruct(startTime, strDesc);
            EditPanelView.getInstance().getInstanceTabEditPanel().setFocusDescriptionTextArea();
        }
    }

    public void reqDeleteScriptData(int startTime) {
        this.compositeScriptAudio.deleteAudioLabel(startTime);
        this.compositeScriptAudio.redrawAudioLabelAll();
    }

    public int setEndTimeVolumeLevel(String currentScript, int currentSpeed, String currentLang) {
        int lengthSample = VolumeLevelCanvas.getInstance().getSamplingLengthVolumeLevel();
        int nowDuration = this.isConsistencyScriptData() && lengthSample > 0 ? lengthSample * 20 : this.sumMoraCount(currentScript, currentSpeed, currentLang);
        int newEndTime = EditPanelView.getInstance().getInstanceTabEditPanel().setEndTimeScriptData(nowDuration);
        return newEndTime;
    }

    public int getCountDurationVoice() {
        return this.countDurationVoice;
    }

    public void setCountDurationVoice(int newCount) {
        this.countDurationVoice = newCount;
    }

    public void incCountDurationVoice() {
        ++this.countDurationVoice;
    }

    public void updateEndTimeVolumeLevel(int index) {
        int lengthSample = this.getCountDurationVoice();
        if (lengthSample > 0) {
            int startTime = this.instScriptData.getScriptStartTime(index);
            int nowDuration = lengthSample * 50;
            int newEndTime = startTime + nowDuration;
            this.instScriptData.updateScriptEndTime(startTime, newEndTime);
            EditPanelView.getInstance().getInstanceTabEditPanel().reqUpdateEndTimeAudioLabel(index, newEndTime);
        }
    }

    public int sumMoraCount(String strDesc, int speed, String lang) {
        int duration = 0;
        int nowPitch = speed >= 50 ? 110 - (speed - 50) : 110 + 4 * (50 - speed);
        duration = "ja-JP".equalsIgnoreCase(lang) ? (int)((float)nowPitch * this.voicePlayer.sumMoraCountJp(strDesc)) : (int)((float)nowPitch * (float)((int)this.voicePlayer.sumMoraCountEn(strDesc)));
        return duration;
    }

    public int getMaxTimeLine() {
        int result = 600000;
        if (result < this.movieEndTimeLine) {
            result = this.movieEndTimeLine;
        }
        if (result < this.endTimeLine) {
            result = this.endTimeLine;
        }
        return result;
    }

    public void setMaxTimeLine(int newEndTime) {
        int intdev = newEndTime / 300000;
        if (newEndTime % 300000 > 0) {
            ++intdev;
        }
        this.endTimeLine = intdev * 300000;
        if (this.endTimeLine > 6000000) {
            this.endTimeLine = 6000000;
        } else if (this.endTimeLine < 600000) {
            this.endTimeLine = 600000;
        }
    }

    public void putScriptAudio(int index, int startTime, int endTime, String strAudio, boolean extended) {
        this.compositeScriptAudio.putAudioLabel(index, startTime, endTime, strAudio, extended);
    }

    public void refreshScriptAudio() {
        this.compositeScriptAudio.refreshScriptAudio();
    }

    public void repaintTimeLine() {
        this.endTimeLine = this.movieEndTimeLine = PreviewPanel.getInstance().getVideoTotalTime();
        int lastIndex = this.instScriptData.getLengthScriptList() - 1;
        if (lastIndex >= 0) {
            int endTime = this.instScriptData.getScriptEndTime(lastIndex);
            if (endTime > this.endTimeLine) {
                this.endTimeLine = endTime;
            }
        } else if (this.endTimeLine == 0) {
            this.endTimeLine = 600000;
        }
        int unitCount = this.endTimeLine / 300000;
        if (this.endTimeLine % 300000 > 0) {
            ++unitCount;
        }
        this.endTimeLine = unitCount * 300000;
    }

    public int adjustEndTimeLine() {
        int result = 0;
        int nowLocation = this.getCurrentValueScrollBar();
        if (this.isEndTimeLine(nowLocation) != 0) {
            this.setCurrentLocation(nowLocation);
            this.repaintAllTimeLine();
            this.reqScrollHorizontalTimeLine(nowLocation);
        }
        return result;
    }

    public void switchActionTimeLine(boolean sw) {
        if (sw) {
            this.reqSeekLocationTimeLine();
            if (this.previousPlayerStatus) {
                this.currentStatusTimeLine = 1;
                this.previousPlayerStatus = false;
            } else {
                this.currentStatusTimeLine = 1;
            }
        } else {
            this.pauseTimeLine = this.currentTimeLine;
            this.currentStatusTimeLine = 4;
            this.previousPlayerStatus = true;
            ScriptListView.getInstance().getInstScriptList().clearHighLightScriptLine();
        }
    }

    public void rewindActionTimeLine() {
        this.previousPlayerStatus = false;
        this.initParamTimeLine(0);
        this.reqInitLocationTimeLine();
    }

    public void resetTimeLine() {
        this.previousPlayerStatus = false;
        this.initParamTimeLine(0);
        this.synchronizeAllTimeLine(this.currentTimeLine);
    }

    private void getCurrentMovieInfo() {
        this.previousMovieStatus = this.currentMovieStatus;
        this.currentMovieStatus = PreviewPanel.getInstance().getVideoStatus();
        this.currentMovieTimeLine = PreviewPanel.getInstance().getVideoCurrentPosition();
    }

    public int getStatusTimeLine() {
        return this.currentStatusTimeLine;
    }

    public void setStatusTimeLine(int nextStatus) {
        this.currentStatusTimeLine = nextStatus;
    }

    private void initParamTimeLine(int nextStatus) {
        this.startTimeLine = 0;
        this.currentTimeLine = 0;
        this.previousTimeLine = -1;
        this.initIndexTimeLine(nextStatus);
    }

    public void initIndexTimeLine(int nextStatus) {
        this.indexScriptData = 0;
        this.ownCurrentTimeLine = this.currentTimeLine;
        this.ownPreviousTimeLine = this.previousTimeLine;
        if (this.instScriptData.getLengthScriptList() <= 0) {
            this.indexScriptData = -1;
        }
    }

    public int seekIndexTimeLine(int targetTime) {
        int index;
        int len = this.instScriptData.getLengthScriptList();
        int previousTime = 0;
        if (len > 0) {
            index = 0;
            while (index < len) {
                int startTime = this.instScriptData.getScriptStartTime(index);
                if (previousTime <= startTime && targetTime <= startTime || startTime <= 100 && startTime + 100 >= targetTime) break;
                previousTime = startTime;
                ++index;
            }
            if (index >= this.instScriptData.getLengthScriptList()) {
                index = -1;
            }
        } else {
            index = -2;
        }
        this.indexScriptData = index;
        this.ownPreviousTimeLine = previousTime;
        return index;
    }

    private void incrementIndexTimeLine() {
        ++this.indexScriptData;
        if (this.indexScriptData >= this.instScriptData.getLengthScriptList()) {
            this.indexScriptData = -1;
        }
    }

    public boolean checkCurrentTimeLine() {
        boolean result = false;
        if (this.currentMovieStatus != -1 && this.ownCurrentTimeLine != this.currentTimeLine) {
            this.ownPreviousTimeLine = this.ownCurrentTimeLine;
            this.ownCurrentTimeLine = this.currentTimeLine;
            if (this.ownPreviousTimeLine > this.ownCurrentTimeLine) {
                this.seekIndexTimeLine(this.ownCurrentTimeLine);
            }
            result = true;
        }
        return result;
    }

    private boolean watchdocIndexTimeLine() {
        boolean result = false;
        if (this.indexScriptData > -1) {
            int startTime = this.instScriptData.getScriptStartTime(this.indexScriptData);
            int endTime = this.instScriptData.getScriptEndTime(this.indexScriptData);
            if (endTime <= this.ownCurrentTimeLine) {
                while (endTime <= this.ownCurrentTimeLine) {
                    this.incrementIndexTimeLine();
                    if (this.indexScriptData == -1) {
                        return result;
                    }
                    startTime = this.instScriptData.getScriptStartTime(this.indexScriptData);
                    endTime = this.instScriptData.getScriptEndTime(this.indexScriptData);
                }
            }
            if (this.ownPreviousTimeLine < startTime && startTime <= this.ownCurrentTimeLine) {
                result = true;
            } else if (startTime <= 100 && endTime >= this.ownCurrentTimeLine) {
                result = true;
            }
        }
        return result;
    }

    private boolean synchronizeCurrentTimeLine() {
        this.getCurrentMovieInfo();
        if (this.currentMovieStatus != -1) {
            if (this.currentTimeLine != this.currentMovieTimeLine) {
                this.previousTimeLine = this.currentTimeLine;
                this.currentTimeLine = this.currentMovieTimeLine;
                return true;
            }
            return false;
        }
        return false;
    }

    private void timerTask() {
        if (this.currentDragStatus) {
            return;
        }
        int nowStat = this.getStatusTimeLine();
        if (!this.synchronizeCurrentTimeLine() && nowStat != 5 && this.previousMovieStatus == this.currentMovieStatus) {
            return;
        }
        boolean result = this.checkCurrentTimeLine();
        if (result || this.previousMovieStatus != this.currentMovieStatus) {
            if (nowStat == 1) {
                boolean result2 = this.watchdocIndexTimeLine();
                if (result2) {
                    if (this.getEnableDescription()) {
                        if (this.isSamplingScriptAudio().booleanValue()) {
                            this.reqStopScriptAudio();
                        }
                        ScriptListView.getInstance().getInstScriptList().updateHighLightScriptLine(this.indexScriptData);
                        this.reqPlayAudio(this.indexScriptData);
                        this.indexCurrentScriptData = this.indexScriptData;
                        this.setCountDurationVoice(0);
                        this.currentVoiceEngineAction = true;
                    }
                    this.incrementIndexTimeLine();
                } else if (this.currentVoiceEngineAction && this.getEnableDescription()) {
                    if (!this.isRunningAudio()) {
                        this.currentVoiceEngineAction = false;
                        this.updateEndTimeVolumeLevel(this.indexCurrentScriptData);
                        ScriptListView.getInstance().getInstScriptList().clearHighLightScriptLine();
                    } else {
                        this.incCountDurationVoice();
                    }
                }
                if (this.videoPlayCount++ >= 3 || this.previousMovieStatus != this.currentMovieStatus) {
                    this.synchronizeAllTimeLine(this.ownCurrentTimeLine);
                    if (this.currentMovieStatus != 1) {
                        eventManager.firePlayerControlEvent(new PlayerControlEvent(this));
                    }
                    this.videoPlayCount = 0;
                }
            } else if (nowStat == 4 || nowStat == 0) {
                if (this.currentMovieTimeLine != this.pauseTimeLine) {
                    this.pauseTimeLine = this.currentMovieTimeLine;
                    this.synchronizeAllTimeLine(this.pauseTimeLine);
                }
                this.currentVoiceEngineAction = false;
                if (this.currentMovieStatus == 1) {
                    eventManager.firePlayerControlEvent(new PlayerControlEvent(this));
                }
            }
        } else if (nowStat == 5) {
            if (!this.isRunningAudio()) {
                PreviewPanel.getInstance().controlExtendedPlay(false);
                this.setStatusTimeLine(1);
                this.currentVoiceEngineAction = false;
                this.updateEndTimeVolumeLevel(this.indexCurrentScriptData);
                ScriptListView.getInstance().getInstScriptList().clearHighLightScriptLine();
            } else {
                this.incCountDurationVoice();
            }
        } else if (nowStat == 4 || nowStat == 0) {
            if (this.currentMovieStatus == 1) {
                eventManager.firePlayerControlEvent(new PlayerControlEvent(this));
            }
            this.currentVoiceEngineAction = false;
        }
    }

    @Override
    public void handleSyncTimeEvent(SyncTimeEvent e) {
        if (e.getEventType() == 0) {
            this.synchronizeTimeLine(e.getCurrentTime());
        }
    }

    @Override
    public void handleMouseDragEvent(MouseDragEvent e) {
        switch (e.getEventType()) {
            case 0: {
                this.currentDragStatus = true;
                break;
            }
            case 1: {
                this.currentDragStatus = true;
                break;
            }
            case 2: {
                this.currentDragStatus = false;
                break;
            }
            case 3: {
                this.currentDragStatus = e.isStatus();
            }
        }
    }

    @Override
    public void handleTimerUtilEvent(TimerEvent e) {
        this.timerUtilCounter += 10;
        if (this.timerUtilCounter >= 50) {
            this.timerTask();
            this.timerUtilCounter = 0;
        }
    }

    class ResizeScrolledCompositeListener
    implements PaintListener {
        ResizeScrolledCompositeListener() {
        }

        public void paintControl(PaintEvent e) {
            if (e.width > 0) {
                Point newPon = TimeLineView.this.childComposite.getLocation();
                TimeLineView.this.childComposite.setLocation(newPon.x + e.width, newPon.y);
            }
        }
    }

    class SliderTimeLineSelectionAdapter
    extends SelectionAdapter {
        SliderTimeLineSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent e) {
            Slider ps = (Slider)e.getSource();
            int nowLocation = ps.getSelection();
            if (TimeLineView.this.isEndTimeLine(nowLocation) != 0) {
                TimeLineView.this.setCurrentLocation(nowLocation);
                TimeLineView.this.repaintAllTimeLine();
            }
            TimeLineView.this.reqScrollHorizontalTimeLine(nowLocation);
        }
    }
}

