/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;
import org.apache.lucene.util.AttributeImpl;
import org.apache.lucene.util.AttributeSource;

public class SingleTokenTokenStream
extends TokenStream {
    private boolean exhausted = false;
    private Token singleToken;
    private final AttributeImpl tokenAtt;
    private static final AttributeSource.AttributeFactory TOKEN_ATTRIBUTE_FACTORY;
    static /* synthetic */ Class class$org$apache$lucene$analysis$Token;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SingleTokenTokenStream(Token token) {
        super(TOKEN_ATTRIBUTE_FACTORY);
        if (!$assertionsDisabled && token == null) {
            throw new AssertionError();
        }
        this.singleToken = (Token)token.clone();
        this.tokenAtt = (AttributeImpl)this.addAttribute(TermAttribute.class);
        if (!($assertionsDisabled || this.tokenAtt instanceof Token || this.tokenAtt.getClass().getName().equals("org.apache.lucene.analysis.TokenWrapper"))) {
            throw new AssertionError();
        }
    }

    public final boolean incrementToken() throws IOException {
        if (this.exhausted) {
            return false;
        }
        this.clearAttributes();
        this.singleToken.copyTo(this.tokenAtt);
        this.exhausted = true;
        return true;
    }

    public final Token next(Token reusableToken) throws IOException {
        return super.next(reusableToken);
    }

    public final Token next() throws IOException {
        return super.next();
    }

    public void reset() throws IOException {
        this.exhausted = false;
    }

    public Token getToken() {
        return (Token)this.singleToken.clone();
    }

    public void setToken(Token token) {
        this.singleToken = (Token)token.clone();
    }

    static {
        $assertionsDisabled = !SingleTokenTokenStream.class.desiredAssertionStatus();
        TOKEN_ATTRIBUTE_FACTORY = new AttributeSource.AttributeFactory(){

            public AttributeImpl createAttributeInstance(Class attClass) {
                return attClass.isAssignableFrom(class$org$apache$lucene$analysis$Token == null ? (class$org$apache$lucene$analysis$Token = SingleTokenTokenStream.class$("org.apache.lucene.analysis.Token")) : class$org$apache$lucene$analysis$Token) ? new Token() : DEFAULT_ATTRIBUTE_FACTORY.createAttributeInstance(attClass);
            }
        };
    }
}

