/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.internal.ui.scripteditor;

import java.io.File;
import org.eclipse.actf.ai.internal.ui.scripteditor.Messages;
import org.eclipse.actf.ai.ui.scripteditor.views.IUNIT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

public class XMLFileMessageBox
implements IUNIT {
    private MessageBox msgBox = null;

    public XMLFileMessageBox(int mode, String filePath) {
        if (this.msgBox == null) {
            int style = 192;
            String strTitle = "";
            String strMessage = "";
            if (mode == 1) {
                strMessage = this.getFileName(filePath);
                style = style | 8 | 0x100;
                strTitle = Messages.xml_dialog_title_confirm;
                strMessage = String.valueOf(strMessage) + Messages.xml_dialog_save_confirm;
            } else if (mode == 2) {
                strMessage = this.getFileName(filePath);
                style |= 8;
                strTitle = Messages.xml_dialog_title_overwrite;
                strMessage = String.valueOf(strMessage) + Messages.xml_dialog_save_overwrite;
            } else if (mode == 3) {
                style = 33;
                strTitle = Messages.xml_dialog_title_error;
                strMessage = Messages.xml_dialog_script_nodesc;
            } else if (mode == 4) {
                style = 33;
                strTitle = Messages.xml_dialog_title_error;
                strMessage = Messages.xml_dialog_script_noexist;
            } else if (mode == 5) {
                style = style | 8 | 0x100;
                strTitle = Messages.xml_dialog_title_modify;
                strMessage = Messages.xml_dialog_save_modify;
            } else if (mode == 6) {
                style = 200;
                strTitle = Messages.xml_dialog_title_confirm;
                strMessage = String.valueOf(Messages.xml_dialog_wav_confirm) + filePath;
            } else if (mode == 7) {
                style = 40;
                strTitle = Messages.xml_dialog_title_confirm;
                strMessage = Messages.xml_dialog_access_denied;
            }
            try {
                this.msgBox = new MessageBox(PlatformUI.getWorkbench().getDisplay().getActiveShell(), style);
                this.msgBox.setText(strTitle);
                this.msgBox.setMessage(strMessage);
            }
            catch (Exception exception) {}
        }
    }

    public int open() {
        int result = -1;
        if (this.msgBox != null) {
            result = this.msgBox.open();
            this.msgBox = null;
        }
        return result;
    }

    private String getFileName(String filePath) {
        String result = "";
        try {
            File fh;
            if (filePath != null && (fh = new File(filePath)) != null) {
                result = "'" + fh.getName() + "' ";
            }
        }
        catch (Exception exception) {}
        return result;
    }
}

