/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.actf.model.flash.bridge.IWaXcoding;
import org.eclipse.actf.model.flash.bridge.WaXcodingFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class FlashModelPlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.actf.model.flash";
    private static FlashModelPlugin plugin;
    private static final Path imposedSWFPath;
    private static final Path bootloaderSWFPath;
    private static final Path bridgeInitSWFPath;
    private static final Path bootloaderSWFV9Path;
    private static final Path bridgeInitSWFV9Path;

    static {
        imposedSWFPath = new Path("bridgeSWF/imposed.swf");
        bootloaderSWFPath = new Path("bridgeSWF/boot_loader.swf");
        bridgeInitSWFPath = new Path("bridgeSWF/boot_bridge.swf");
        bootloaderSWFV9Path = new Path("bridgeSWF/v9/bootloader_as3.swf");
        bridgeInitSWFV9Path = new Path("bridgeSWF/v9/bridge_as3.swf");
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        InputStream inputStream = this.tryOpenStream(imposedSWFPath);
        IWaXcoding iWaXcoding = WaXcodingFactory.getWaXcoding();
        if (inputStream != null) {
            iWaXcoding.setSWFTranscodingImposedFile(inputStream);
        }
        if ((inputStream = this.tryOpenStream(bootloaderSWFPath)) != null) {
            iWaXcoding.setSWFBootloader(inputStream);
        }
        if ((inputStream = this.tryOpenStream(bridgeInitSWFPath)) != null) {
            iWaXcoding.setSWFBridgeInit(inputStream);
        }
        if ((inputStream = this.tryOpenStream(bootloaderSWFV9Path)) != null) {
            iWaXcoding.setSWFBootloaderV9(inputStream);
        }
        if ((inputStream = this.tryOpenStream(bridgeInitSWFV9Path)) != null) {
            iWaXcoding.setSWFBridgeInitV9(inputStream);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        plugin = null;
        super.stop(bundleContext);
    }

    public static FlashModelPlugin getDefault() {
        return plugin;
    }

    private InputStream tryOpenStream(Path path) {
        try {
            return FileLocator.openStream((Bundle)this.getBundle(), (IPath)path, (boolean)false);
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

