/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ui.util;

import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;

public class HighlightStringListener
implements LineStyleListener {
    private Vector<HighlightInfo> highlightInfoV = new Vector();

    public void addTarget(String string, Color color) {
        HighlightInfo highlightInfo = new HighlightInfo(string, color);
        this.highlightInfoV.add(highlightInfo);
    }

    public void addTarget(String string, Color color, int n) {
        HighlightInfo highlightInfo = new HighlightInfo(string, color);
        highlightInfo.setStyle(n);
        this.highlightInfoV.add(highlightInfo);
    }

    public void lineGetStyle(LineStyleEvent lineStyleEvent) {
        String string = lineStyleEvent.lineText;
        int n = 0;
        int n2 = 0;
        ArrayList<StyleRange> arrayList = new ArrayList<StyleRange>();
        for (HighlightInfo highlightInfo : this.highlightInfoV) {
            String string2 = highlightInfo.getTargetS();
            while ((n2 = string.indexOf(string2, n)) != -1) {
                StyleRange styleRange = new StyleRange();
                styleRange.start = lineStyleEvent.lineOffset + n2;
                styleRange.length = string2.length();
                styleRange.foreground = highlightInfo.getFgColor();
                styleRange.background = highlightInfo.getBgColor();
                styleRange.fontStyle = highlightInfo.getStyle();
                arrayList.add(styleRange);
                n = n2 + string2.length();
            }
        }
        lineStyleEvent.styles = arrayList.toArray(new StyleRange[arrayList.size()]);
    }

    private class HighlightInfo {
        String targetS;
        Color fgColor;
        Color bgColor;
        int style;

        public HighlightInfo(String string, Color color) {
            this(string, color, null, 0);
        }

        public HighlightInfo(String string, Color color, Color color2, int n) {
            this.targetS = string;
            this.fgColor = color;
            this.bgColor = color2;
            this.style = n;
        }

        public Color getBgColor() {
            return this.bgColor;
        }

        public Color getFgColor() {
            return this.fgColor;
        }

        public int getStyle() {
            return this.style;
        }

        public void setStyle(int n) {
            this.style = n;
        }

        public String getTargetS() {
            return this.targetS;
        }
    }
}

