/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.ui.report.srcviewer;

import java.io.File;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetSourceInfo;
import org.eclipse.actf.visualization.internal.ui.report.Messages;
import org.eclipse.actf.visualization.internal.ui.report.ReportPlugin;
import org.eclipse.actf.visualization.internal.ui.report.srcviewer.SrcViewer;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SrcViewerForPT {
    private static SrcViewerForPT INSTANCE = null;
    private static SrcViewer _srcViewer;
    private static Shell _srcViewerShell;
    private Shell _shell = null;
    private boolean srcChanged;
    private File curTarget;

    private SrcViewerForPT(Shell shell) {
        this._shell = shell;
        this.initSrcViewer();
    }

    public static SrcViewerForPT initSrcViewerForPT(Shell shell) {
        INSTANCE = new SrcViewerForPT(shell);
        return INSTANCE;
    }

    public static SrcViewerForPT getInstance() {
        return INSTANCE;
    }

    private void initSrcViewer() {
        this.srcChanged = true;
        if (this._shell != null) {
            this._shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent shellEvent) {
                    if (_srcViewerShell != null && !_srcViewerShell.isDisposed()) {
                        _srcViewerShell.dispose();
                    }
                }
            });
        }
    }

    public void openSrcViewer() {
        if (_srcViewerShell == null || _srcViewerShell.isDisposed()) {
            Display display = this._shell.getDisplay();
            if (display == null) {
                display = Display.getDefault();
            }
            _srcViewerShell = new Shell(display);
            _srcViewerShell.setLayout((Layout)new FillLayout());
            _srcViewerShell.setImage(ReportPlugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.visualization.ui.report", (String)"icons/excla_squ.png").createImage());
            _srcViewerShell.setText(Messages.SrcViewerForPT_0);
            _srcViewer = new SrcViewer((Composite)_srcViewerShell);
            _srcViewerShell.setSize(600, 750);
            _srcViewerShell.setFocus();
            _srcViewerShell.open();
            _srcViewerShell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent shellEvent) {
                    _srcViewer.closeSearchDlgShell();
                }
            });
            this.srcChanged = true;
        } else if (!_srcViewerShell.isDisposed()) {
            if (_srcViewerShell.getMinimized()) {
                _srcViewerShell.setMinimized(false);
            }
            _srcViewerShell.forceActive();
        }
    }

    public void highlightSrcViewer(HighlightTargetSourceInfo[] highlightTargetSourceInfoArray, File file) {
        if (_srcViewerShell != null && !_srcViewerShell.isDisposed()) {
            if (this.curTarget != file || this.srcChanged) {
                this.srcChanged = true;
                this.updateSrcViewer(file);
            }
            _srcViewer.clearHighlight();
            int n = 0;
            while (n < highlightTargetSourceInfoArray.length) {
                HighlightTargetSourceInfo highlightTargetSourceInfo = highlightTargetSourceInfoArray[n];
                if (highlightTargetSourceInfo.getStartColumn() < 0 || highlightTargetSourceInfo.getEndColumn() < 0) {
                    _srcViewer.highlightLines(highlightTargetSourceInfo.getStartLine(), highlightTargetSourceInfo.getEndLine());
                } else {
                    _srcViewer.highlight(highlightTargetSourceInfo.getStartLine(), highlightTargetSourceInfo.getStartColumn(), highlightTargetSourceInfo.getEndLine(), highlightTargetSourceInfo.getEndColumn());
                }
                ++n;
            }
        }
    }

    public void updateSrcViewer(File file) {
        if (_srcViewerShell != null && !_srcViewerShell.isDisposed() && this.srcChanged) {
            try {
                _srcViewer.openFile(file);
                this.curTarget = file;
            }
            catch (Exception exception) {
                _srcViewer.setText("");
            }
            this.srcChanged = false;
        }
    }

    public void setSrcChanged(boolean bl) {
        this.srcChanged = bl;
    }
}

