/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.logging;

import java.util.logging.Level;
import java.util.logging.Logger;

public final class LoggingUtil {
    public static final String ACCSERVICE_LOGGER_NAME = "org.eclipse.actf.accservice";
    public static final String ACTF_CORE_LOGGER_NAME = "org.eclipse.actf.core";
    public static final String ACTF_VALIDATION_LOGGER_NAME = "org.eclipse.actf.validation";
    public static final String ACTF_JAVACO_LOGGER_NAME = "org.eclipse.actf.javaco";
    public static final String ACTF_WEBELO_LOGGER_NAME = "org.eclipse.actf.webelo";
    public static final String ACTF_UI_LOGGER_NAME = "org.eclipse.actf.ui";

    protected LoggingUtil() {
    }

    public static void printParams(Logger logger, Object[] objectArray) {
        if (logger != null) {
            logger.log(Level.FINE, "With parameters:");
            int n = 0;
            while (objectArray != null && n < objectArray.length) {
                logger.log(Level.FINE, String.valueOf(objectArray[n] == null ? "" : objectArray[n].getClass().getName()) + ":" + objectArray[n] + (n < objectArray.length - 1 ? ", " : ""));
                ++n;
            }
        }
    }

    public static String firstCharToUpper(String string) {
        return String.valueOf(Character.toUpperCase(string.charAt(0))) + string.substring(1);
    }

    public static String arrayAsString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(stringArray[n]);
            if (n < stringArray.length - 1) {
                stringBuffer.append('\n');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Throwable getRootException(Throwable throwable) {
        Throwable throwable2 = throwable;
        while ((throwable = throwable.getCause()) != null) {
            throwable2 = throwable;
        }
        return throwable2;
    }

    public static String escape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\"') {
                stringBuffer.append("&quote;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c < ' ' || c > '~') {
                stringBuffer.append("&#");
                String string2 = Integer.toHexString(c);
                if (string2.length() % 2 != 0) {
                    stringBuffer.append("0");
                }
                stringBuffer.append(string2);
                stringBuffer.append(";");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

