/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.ease.internal.menu;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.ease.ui.scripts.repository.IRepositoryService;
import org.eclipse.ease.ui.scripts.repository.IScript;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.core.annotations.TaskChainContextInit;
import org.eclipse.tea.core.annotations.TaskChainSuppressLifecycle;
import org.eclipse.tea.core.services.TaskChain;
import org.eclipse.tea.core.services.TaskingAdditionalMenuEntryProvider;
import org.eclipse.tea.ease.EaseScriptTask;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.component.annotations.Component;

@Component
public class EaseScriptProvider
implements TaskingAdditionalMenuEntryProvider {
    private static final String KEYWORD_NAME = "name";
    private static final String KEYWORD_IMAGE = "image";
    private static final String KEYWORD_TEA = "tea";
    private static final String KEYWORD_DEV = "tea-dev";
    private static final String KEYWORD_GROUPING = "tea-grouping";

    public List<TaskingAdditionalMenuEntryProvider.TaskingAdditionalMenuEntry> getAdditionalEntries() {
        ArrayList<TaskingAdditionalMenuEntryProvider.TaskingAdditionalMenuEntry> allEntries = new ArrayList<TaskingAdditionalMenuEntryProvider.TaskingAdditionalMenuEntry>();
        IRepositoryService repoService = (IRepositoryService)PlatformUI.getWorkbench().getService(IRepositoryService.class);
        for (IScript script : repoService.getScripts()) {
            Map keywords = script.getKeywords();
            if (!Boolean.parseBoolean((String)keywords.get(KEYWORD_TEA))) continue;
            String[] menuPath = null;
            String path = (String)keywords.get(KEYWORD_NAME);
            if (path != null && !path.isEmpty() && path.contains("/")) {
                menuPath = Splitter.on((char)'/').splitToList((CharSequence)path.substring(0, path.lastIndexOf(47))).toArray(new String[0]);
            }
            allEntries.add(new TaskingAdditionalMenuEntryProvider.TaskingAdditionalMenuEntry((TaskChain)new EaseSingleScriptChain(script.getPath().toString(), script.getName()), menuPath, (String)keywords.get(KEYWORD_IMAGE), (String)keywords.get(KEYWORD_GROUPING), Boolean.parseBoolean((String)keywords.get(KEYWORD_DEV))));
        }
        return allEntries;
    }

    @TaskChainSuppressLifecycle
    private static final class EaseSingleScriptChain
    implements TaskChain {
        private final String name;
        private final String label;

        public EaseSingleScriptChain(String name, String label) {
            this.name = name;
            this.label = label;
        }

        @TaskChainContextInit
        public void init(TaskExecutionContext c) {
            c.addTask((Object)new EaseScriptTask(this.name));
        }

        public String toString() {
            return this.label;
        }
    }
}

