/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table.tree;

import com.google.common.collect.Iterables;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stell_Bereich;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.RowGroupExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.model.validationreport.ValidationProblem;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.table.AbstractTableModelTransformator;
import org.eclipse.set.utils.table.TMFactory;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public abstract class AbstractValidationProblemTransformator<T>
extends AbstractTableModelTransformator<T> {
    private Set<ValidationProblem> listProblems = CollectionLiterals.newHashSet();

    @Override
    public Table transformTableContent(T report, TMFactory factory) {
        Consumer<ValidationProblem> _function = it -> {
            this.transformProblem(factory, (ValidationProblem)it);
            this.listProblems.add((ValidationProblem)it);
        };
        this.getProblems(report).forEach(_function);
        this.instertGroupAbstractRow(factory);
        this.reGroupingTree(factory);
        return factory.getTable();
    }

    @Override
    public Table transformTableContent(T model, TMFactory factory, Stell_Bereich controlArea) {
        throw new UnsupportedOperationException();
    }

    public abstract List<ValidationProblem> getProblems(T var1);

    protected void transformProblem(TMFactory factory, ValidationProblem problem) {
        TableRow instance = factory.newTableRow(problem.getId(), TableExtensions.getColumns((Table)factory.getTable()));
        this.fillProblem(instance, problem);
        RowGroup rowGroup = RowGroupExtensions.findRowGroup((Table)factory.getTable(), (TableRow)instance, this.getExcludeColumns());
        if (rowGroup != null) {
            rowGroup.getRows().add((Object)instance);
        } else {
            factory.newRowGroup(null).getRowGroup().getRows().add((Object)instance);
        }
    }

    public abstract void fillProblem(TableRow var1, ValidationProblem var2);

    private void instertGroupAbstractRow(TMFactory factory) {
        Functions.Function1 _function = it -> {
            int _tableTreeMinimum;
            int _size = it.getRows().size();
            return _size >= (_tableTreeMinimum = ToolboxConfiguration.getTableTreeMinimum());
        };
        Iterable rowGroups = IterableExtensions.filter((Iterable)factory.getTable().getTablecontent().getRowgroups(), (Functions.Function1)_function);
        Consumer<RowGroup> _function_1 = it -> {
            EList _rows = it.getRows();
            List sortedRows = IterableExtensions.sortWith((Iterable)_rows, (Comparator)new Comparator<TableRow>(){

                @Override
                public int compare(TableRow r1, TableRow r2) {
                    return Integer.valueOf(r1.getRowIndex()).compareTo(r2.getRowIndex());
                }
            });
            it.getRows().add(0, (Object)this.createGroupAbstractRow(factory, sortedRows));
        };
        rowGroups.forEach(_function_1);
    }

    protected TableRow createGroupAbstractRow(TMFactory factory, List<TableRow> groupRows) {
        TableRow rootRow = factory.createGeneralGroupRow(groupRows.get(0), this.getExcludeColumns());
        ColumnDescriptor _indexColumn = this.getIndexColumn();
        StringConcatenation _builder = new StringConcatenation();
        int _rowIndex = groupRows.get(0).getRowIndex();
        _builder.append((Object)_rowIndex);
        _builder.append("..");
        int _rowIndex_1 = groupRows.getLast().getRowIndex();
        _builder.append((Object)_rowIndex_1);
        TableRowExtensions.set((TableRow)rootRow, (ColumnDescriptor)_indexColumn, (String)_builder.toString());
        Functions.Function1 _function = it -> {
            int _rowIndex_2;
            int _id = it.getId();
            return _id == (_rowIndex_2 = ((TableRow)groupRows.get(0)).getRowIndex());
        };
        ValidationProblem _findFirst = (ValidationProblem)IterableExtensions.findFirst(this.listProblems, (Functions.Function1)_function);
        String _generalMsg = null;
        if (_findFirst != null) {
            _generalMsg = _findFirst.getGeneralMsg();
        }
        String generalErroMsg = _generalMsg;
        TableRowExtensions.set((TableRow)rootRow, (ColumnDescriptor)this.getMessagesColumn(), (String)generalErroMsg);
        return rootRow;
    }

    protected void reGroupingTree(TMFactory factory) {
        EList tableRowGroups = factory.getTable().getTablecontent().getRowgroups();
        Functions.Function1 _function = it -> it.getRows().size() < ToolboxConfiguration.getTableTreeMinimum() && it.getRows().size() > 1;
        Iterable extractRowGroups = IterableExtensions.filter((Iterable)tableRowGroups, (Functions.Function1)_function);
        Functions.Function1 _function_1 = it -> it.getRows().subList(1, it.getRows().size());
        Set rows = IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)extractRowGroups, (Functions.Function1)_function_1)));
        Consumer<TableRow> _function_2 = row -> {
            RowGroup newGroup = factory.getRowGroup();
            newGroup.getRows().add(row);
        };
        rows.forEach(_function_2);
    }

    public abstract List<ColumnDescriptor> getExcludeColumns();

    public abstract ColumnDescriptor getIndexColumn();

    public abstract ColumnDescriptor getMessagesColumn();
}

