/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stell_Bereich;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.TablemodelFactory;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.model.tablemodel.format.TextAlignment;
import org.eclipse.set.utils.table.ColumnDescriptorModelBuilder;
import org.eclipse.set.utils.table.TMFactory;
import org.eclipse.set.utils.table.TableError;
import org.eclipse.set.utils.table.TableModelTransformator;
import org.eclipse.set.utils.table.TableTransformationService;
import org.eclipse.set.utils.table.sorting.ComparatorBuilder;
import org.eclipse.set.utils.table.sorting.TableRowGroupComparator;

public abstract class AbstractTableTransformationService<T>
implements TableTransformationService<T> {
    protected static final float LINE_HEIGHT = 0.6f;
    protected TableModelTransformator<T> transformator;

    protected AbstractTableTransformationService() {
    }

    public abstract TableModelTransformator<T> createTransformator();

    protected abstract ColumnDescriptor fillHeaderDescriptions(ColumnDescriptorModelBuilder var1);

    protected void setColumnTextAlignment(Table table) {
        List columns = TableExtensions.getColumns((Table)table);
        TableExtensions.setTextAlignment((Table)table, (int)0, (TextAlignment)TextAlignment.LEFT);
        TableExtensions.setTextAlignment((Table)table, (int)(columns.size() - 1), (TextAlignment)TextAlignment.LEFT);
    }

    @Override
    public void format(Table table) {
        if (table == null) {
            return;
        }
        this.transformator = this.createTransformator();
        this.setColumnTextAlignment(table);
    }

    @Override
    public Comparator<RowGroup> getRowGroupComparator() {
        return TableRowGroupComparator.builder().sort("A", ComparatorBuilder.CellComparatorType.LEXICOGRAPHICAL, SortDirectionEnum.ASC).build();
    }

    @Override
    public Table transform(T model, Stell_Bereich controlArea) {
        Table table = TablemodelFactory.eINSTANCE.createTable();
        this.buildHeading(table);
        this.transformator = this.createTransformator();
        this.transformator.transformTableContent(model, new TMFactory(table), controlArea);
        TableExtensions.getTableRows((Table)table).forEach(row -> {
            int i = 0;
            while (i < row.getCells().size()) {
                if (((TableCell)row.getCells().get(i)).getContent() == null) {
                    TableRowExtensions.set((TableRow)row, (int)i, (String)"");
                }
                ++i;
            }
        });
        this.setColumnTextAlignment(table);
        return table;
    }

    @Override
    public Table transform(T model) {
        Table table = TablemodelFactory.eINSTANCE.createTable();
        this.buildHeading(table);
        this.transformator = this.createTransformator();
        this.transformator.transformTableContent(model, new TMFactory(table));
        this.setColumnTextAlignment(table);
        return table;
    }

    @Override
    public Collection<TableError> getTableErrors() {
        if (this.transformator != null) {
            return this.transformator.getTableErrors();
        }
        return new ArrayList<TableError>();
    }

    public ColumnDescriptor buildHeading(Table table) {
        ColumnDescriptorModelBuilder builder = new ColumnDescriptorModelBuilder(table);
        return this.fillHeaderDescriptions(builder);
    }
}

