/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.browser.cef.handlers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.set.browser.cef.Chromium;
import org.eclipse.set.browser.cef.handlers.ResourceHandler;
import org.eclipse.set.browser.lib.ChromiumLib;
import org.eclipse.set.browser.lib.cef_browser_t;

public class SchemeHandlerFactory {
    private final Map<Integer, Chromium> browsers = new HashMap<Integer, Chromium>();
    private final long cefSchemeHandlerFactory;
    private final String name;

    public SchemeHandlerFactory(String name, Chromium browser) {
        this.name = name;
        this.cefSchemeHandlerFactory = ChromiumLib.allocate_cef_scheme_handler_factory_t((Object)this);
        ChromiumLib.cefswt_register_http_host((String)name, (long)this.cefSchemeHandlerFactory);
        this.addBrowser(browser);
    }

    public void addBrowser(Chromium browser) {
        this.browsers.put(browser.getBrowserId(), browser);
    }

    public void dispose() {
        ChromiumLib.cefswt_register_http_host((String)this.name, (long)0L);
        ChromiumLib.deallocate_cef_scheme_handler_factory_t((long)this.cefSchemeHandlerFactory);
    }

    public long get() {
        return this.cefSchemeHandlerFactory;
    }

    public boolean removeBrowser(Chromium browser) {
        Integer id = browser.getBrowserId();
        this.browsers.remove(id);
        return this.browsers.isEmpty();
    }

    private long create(long self, long browser_id, long frame, long scheme_name, long request) {
        Integer id = cef_browser_t.cefswt_get_id((long)browser_id);
        Chromium browser = this.browsers.get(id);
        if (browser == null) {
            return 0L;
        }
        ResourceHandler resHandler = browser.onRequestCustomHandler(this.name);
        if (resHandler != null) {
            return resHandler.get();
        }
        return 0L;
    }
}

