/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions.internal;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.set.basis.DomainElementList;
import org.eclipse.set.basis.attachments.Attachment;
import org.eclipse.set.basis.attachments.AttachmentInfo;
import org.eclipse.set.basis.files.AttachmentContentService;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang;
import org.eclipse.set.ppmodel.extensions.AnhangTransformation;
import org.eclipse.set.ppmodel.extensions.AttachmentExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class AttachmentProxyList
implements DomainElementList<Attachment, AttachmentInfo<Attachment>> {
    private final DomainElementList<Anhang, AttachmentInfo<Anhang>> original;
    private final List<DomainElementList.ChangeListener<Attachment>> changeListenerList = new LinkedList<DomainElementList.ChangeListener<Attachment>>();
    private DomainElementList.ChangeListener<Anhang> originalChangeListener;
    private final AnhangTransformation transformation;

    public AttachmentProxyList(DomainElementList<Anhang, AttachmentInfo<Anhang>> original, EnumTranslationService translationService, AttachmentContentService contentService) {
        this.original = original;
        this.transformation = AnhangTransformation.createTransformation(translationService, contentService);
    }

    public List<Attachment> getElements() {
        return this.transformation.toAttachment(this.original.getElements());
    }

    public void add(AttachmentInfo<Attachment> attachmentInfo) {
        this.original.add(AttachmentExtensions.createAnhang(attachmentInfo));
    }

    public void addChangeListener(DomainElementList.ChangeListener<Attachment> changeListener) {
        if (this.originalChangeListener == null) {
            this.originalChangeListener = new DomainElementList.ChangeListener<Anhang>(){

                public void listChanged(Notification msg) {
                    Consumer<DomainElementList.ChangeListener> _function = it -> it.listChanged(msg);
                    AttachmentProxyList.this.changeListenerList.forEach(_function);
                }
            };
            this.original.addChangeListener(this.originalChangeListener);
        }
        this.changeListenerList.add(changeListener);
    }

    public void removeChangeListener(DomainElementList.ChangeListener<Attachment> changeListener) {
        this.changeListenerList.remove(changeListener);
        if (this.changeListenerList.isEmpty() && this.originalChangeListener != null) {
            this.original.removeChangeListener(this.originalChangeListener);
            this.originalChangeListener = null;
        }
    }

    public void remove(Attachment attachment) {
        boolean _equals;
        Functions.Function1 _function = it -> {
            String _wert = it.getIdentitaet().getWert();
            String _id = attachment.getId();
            return Objects.equals(_wert, _id);
        };
        List anhaenge = IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)this.original.getElements(), (Functions.Function1)_function));
        int _size = anhaenge.size();
        boolean bl = _equals = _size == 1;
        if (!_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Attachment ");
            String _id = attachment.getId();
            _builder.append(_id);
            _builder.append(" not found.");
            throw new IllegalArgumentException(_builder.toString());
        }
        this.original.remove((Object)((Anhang)anhaenge.get(0)));
    }

    public EObject getContainer() {
        return this.original.getContainer();
    }

    public EStructuralFeature getContainingFeature() {
        return this.original.getContainingFeature();
    }

    public EStructuralFeature getFeature() {
        return this.original.getFeature();
    }
}

